;+
; TIME_MENU
;       Select start and stop times for plotting data.
;
; Call:
;       time
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;       Prototype (after time & dir_menu) : 5/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Rotate input focus: 11/2/93; SJT
;	Add UDS replot flag: 4/11/94; SJT
;	Fix for dates beyond 2000: 1/12/95; SJT
;-

pro time_event, event

@time_limits
@flags
@cdf_flags
@spec_flags
@pad_flags
@b_flags
@uds_flags
@pha_flags

@time_wid

widget_control, get_uval=i, event.id

case i of
    'Cancel': begin
	widget_control, event.top, /destroy
	return
    end

    'Done': begin
        widget_control, start_wid, get_val=st
	tstart = conv_time_str(st(0))
	tstart(0) = date100(tstart(0), /print)
	hstart = hours(tstart(0:1),[90,318])

	widget_control, stop_wid, get_val=st
	tstop = conv_time_str(st(0))
	tstop(0) = date100(tstop(0), /print)

        spc_replot_ok = 0
        uds_replot_ok = 0
	cdf_replot_ok = 0
        pad_replot_ok = 0
        pha_replot_ok = 0
	b_replot_ok = 0
	replot_ok = 0

	if (compare_times(tstart, tstop) ge 0) then begin
	    hs_err_msg, 'End time must be greater than start time.'
	    return
	endif

	widget_control, event.top, /destroy
	return
    end

;	Switch input focus  if return is hit on the windows

    'START': widget_control, stop_wid, /input_focus
    'STOP': widget_control, start_wid, /input_focus

;	copy values from one window to the other

    'E-B': begin
	widget_control, stop_wid, get_val=st
	widget_control, start_wid, set_value=st, /input_focus
    end

    'B-E': begin
	widget_control, start_wid, get_value=st
	widget_control, stop_wid, set_val=st, /input_focus
    end

endcase

end

pro time_menu, group=group

@time_limits
@flags
@cdf_flags
@spec_flags
@uds_flags
@pad_flags
@b_flags
@time_wid
@wid_fonts

if (xregistered('time')) then return	; Don't make a second copy.

if n_elements(tstart) eq 0 then begin
    tstart = (tstop = intarr(4))
    ss0 = (ss1 = '')
endif else begin
    ss0 = string(tstart, format="(4(i4,:,','))")
    ss1 = string(tstop, format="(4(i4,:,','))")
endelse

note = ['N.B. Times must be in the form y, d, h, m', $
	'with the fields separated by commas']

base = widget_base(/column, xpad=5, ypad=5, title='Time Limits')
txt = widget_label (base, value='Set Time Limits', frame=2, font=large_v)
notw = widget_text (base, value=note, xsize=max(strlen(note)), $
	ysize=n_elements(note), font=normal_v)

sbase = widget_base(base, /row, /frame)
sl = widget_label(sbase, value='Start Time', font=normal_v)
start_wid = widget_text(sbase, /edit, value=ss0, uvalue='START', $
	/frame, ysize=1, xsize=24, font=normal_f)
ebut = widget_button(sbase, value='End Time', uvalue='E-B', font=normal_v)

ebase = widget_base(base, /row, /frame)
el = widget_label(ebase, value='End Time', font=normal_v)
stop_wid = widget_text(ebase, /edit, value=ss1, uvalue='STOP', $
	/frame, ysize=1, xsize=24, font=normal_f)
sbut = widget_button(ebase, value='Start Time', uvalue='B-E', font=normal_v)

;	 buttons to return to the main menu

junk = widget_base(base, /row)
cbut = widget_button (junk, value='Cancel', uvalue='Cancel', font=normal_v)
dbut = widget_button (junk, value='Do it', uvalue='Done', font=normal_v)

widget_control, /real, base
widget_control, start_wid, /input_focus
xmanager, 'time', base, group=group

end
