pro sqpage, nplots, cdef, rdef

;+
;  SQPAGE
;	Find best approximateion to a square page for a given # of plots.
;
;  Usage:
;	sqpage, nplots, cdef, rdef
;
;  Arguments:
;	nplots	int	input	The number of plots on the page
;	cdef	int	output	The number of columns
;	rdef	int	output	The number of rows
;
;  History:
;	Original: 5/11/92; SJT
;-

xrdef = sqrt(float(nplots))
rdef = fix(xrdef)
if (rdef lt xrdef) then rdef = rdef+1

cdef = nplots / rdef + ((nplots mod rdef) ne 0)

end
