pro show_hdf, file, program=program

;+
; SHOW_HDF
;	Display the image or images in an HDF file. (called by show_hdf)
;
; Usage:
;	show_hdf[, file, program=program]
;
; Argument:
;	file	string	input	The hdf file.
;
; Keyword:
;	program	string	input	The program generating the hdf file.
;
; History:
;	First version: 20/2/91; SJT
;	Converted to routine and tidied up: 28/4/92; SJT
;	Spool after each plot, modifcations to ctables etc: 28/10/92; SJT
;	Renamed show_hdf_vms - to allow entirely different method in unix:
;							24/11/92; SJT
;	Restored to show_hdf to use V3 builtin HDF: 29/11/93; SJT
;-

@directories
@plot_settings
@time_limits
@wid_set

if (fix(!version.release) lt 3) then begin
    hs_err_msg, ["SHOW_HDF now uses the internal IDL HDF calls", $
		 "this needs version 3.0.0 or higher, you have "+ $
			!version.release]
    return
end

if (not wid_mode) then print, 'ULYSSES/LAN HDF Image Display', $
			      '=============================', $
			      format = "(t25,a/t25,a)"

if (n_params() eq 1 and keyword_set(program)) then begin
    hs_err_msg, $
	'**** ERROR **** May not specify filename and generating program'
    return
endif

if (n_params() eq 1 or keyword_set(program)) then it1 = 1 $
else						  it1 = 0

if (n_elements(pldir) eq 0 and not wid_mode) then set_dir
if (keyword_set(program)) then begin
    if (n_elements(tstart) eq 0) then time
    iy = fix(tstart(0))
    id = fix(tstart(1))
    ily = 365 + ((iy mod 4) eq 0)
endif
if (n_elements(pldname) eq 0) then plopen

getfile:

if (it1) then begin
    if (n_params() eq 1) then hdffile = file $
    else if keyword_set(program) then $
		hdffile = strlowcase(program) + string(iy,id, $
			format = "(i2.2,i3.3,'.hdf')")
endif else begin
    hdffile = '' 
    read, 'HDF image file :_', hdffile
endelse

;		This cascade allows us to try to find the file in:
;		The plot file directory
;		The data directory or
;		The current directory,
;		in that order.

if (wid_mode and not keyword_set(program)) then $
		isdf = hdf_ishdf((fullfile = hdffile)) $
else begin
    isdf = hdf_ishdf((fullfile = form_fname(hdffile,pldir)))
    if (not isdf) then begin
        isdf = hdf_ishdf((fullfile = form_fname(hdffile,dir)))
        if (not isdf) then isdf = hdf_ishdf((fullfile = hdffile))
    endif
endelse

if (not isdf) then begin
    if (keyword_set(program)) then begin
	id = id+1
	if (id gt ily) then begin
	    id = 1
	    iy = iy+1
	endif
	it1 = 1
        if (iy lt tstop(0) or (iy eq tstop(0) and id lt tstop(1)) or $
	    (iy eq tstop(0) and id eq tstop(1) and $
		(tstop(2) ne 0. or tstop(3) ne 0.))) then goto, getfile $
	else it1 = 0
    endif else begin
	it1 = 0
    endelse
    goto, getfile
endif else hs_err_msg, 'Opened HDF file: '+ fullfile

hdffile = fullfile

hs_err_msg, /nostar, string((nimages = dfr8_nimages(hdffile)), $
	format = "('File contains ',I2,' images')")

for im = 1, nimages do begin


;		Read the image (and palette if appropriate), and the label
;		associated with that image.

	dfr8_getimage,hdffile, image, pal
	sim = size(image)
        hs_err_msg, 'Image '+string(im,format="(i2)")+' is '+ $
		string(sim(1:2),format="(I3,'x',I3)")
        if (max(image) eq min(image)) then begin	; Dud image
	    hs_err_msg, /nostar, ['Image contains only one value', $
		         'Cannot usefully plot it']
	    goto, end_of_loop
        endif

	if (not coltab) then  begin

	    bwfix = hdf_bg(hdffile, min(image))

	    if (bwfix) then begin
		h = histogram(image)
		pk = max(h, cbg)
	        if (cbg ne max(image)) then ctex = max(image) $
		else		            ctex = 1
	        image(where(image eq ctex)) = 0b
		image(where(image eq cbg)) = 255b
	    endif
	endif

	plotset, /nowindow

	if ((!d.flags and 256) ne 0) then $
		window, xsize=sim(1), ysize=sim(2), /free, $
		title = hdffile + ': Image ' + string(im, format="(i2)"), $
		retain=2, color=256
 
;		Load colour table, the display image (top down) and add the
;		label above it.

	erase
	if coltab then begin

;		Check if this is an image from the APL software with a shifted
;		palette. Background =1 and white is pal(*,0).
;		If so then roll the palette by 1.

	    h = histogram(image)
	    junk = max(h, hmax)
	    df_pal_col, pal, min(image), white=hmax
	    bwfix = 0
	endif

	if (size(image))(1) gt !d.x_vsize then begin
	    image = image(0:!d.x_vsize-1,*)
	    x_crop = 1
	endif else x_crop = 0

	if (size(image))(2) gt !d.y_vsize then image = image(*,0:!d.y_vsize-1)

	if ((!d.flags and 1) eq 0) and not x_crop then ixo = (!d.x_vsize - sim(1))/2 $
	else                          ixo = 0l

	tv, /order, image, ixo, 0

	dummy = '' 
	close_plot
	if (not hard) then if (cont_prompt() eq 0) then goto, abandon

end_of_loop:

endfor

if (keyword_set(program)) then begin
    id = id+1
    if (id gt ily) then begin
        id = 1
        iy = iy+1
    endif
    it1 = 1
    if (iy lt tstop(0) or (iy eq tstop(0) and id lt tstop(1)) or $
	(iy eq tstop(0) and id eq tstop(1) and $
		(tstop(2) ne 0. or tstop(3) ne 0.))) then goto, getfile
endif

abandon:
dfr8_restart

end

