pro set_region, x1, y1, x2, y2

;+
; SET_REGION
;	Sets a region to plot. The region is defined in Normalized coordinates
;	and is used to define a reduced region for rates plots.
;	This is designed as a "stand-alone" procedure to be called prior to
;	running MFSA_RATES.
;
; Call:
;	set_region, x1, [y1, x2, y2]
;
; Arguments:
;	x1	float	input	If one argument is given than this is an array
;				with the coordinates (xlo, ylo, xhi, yhi),
;				if 4 arguments are given then the x-coord of
;				the left edge of the plot
;	y1	float	input	The y coordinate of the bottom of the plot.
;	x2, y2	float	input	the x and y coordinates of the right and top of
;				the plot.
;
; Common:
;	plot_reg	Set to the values passed.
;
; History:
;	Prototype: 5/2/91; SJT
;	Changed to send messages via MESSAGE: 6/2/91; SJT
;-

; Formats:
arrel = "('called with argument ',A,' array of length', I3/" + $
	"'Cannot use this to form a valid region')"
range = "('argument out of range (max is ',F6.2,', min is ',F6.2,')')"
badargs = "('called with ',I2,' arguments: First has ',I3," + $
 	"' elements'/'Cannot form a valid region')"

@plot_reg

case 1 of
    (n_params() eq 4): begin		; Simple scalar parameters.
	if (n_elements(x1) ne 1) then begin
	    mstr = strcompress(string('X1', n_elements(x1), format=arrel))
	    message, /inform, /noprefix, mstr(0)
	    message, /inform, /noprefix, /noname, mstr(1)
	    return
	endif
	if (n_elements(y1) ne 1) then begin
	    mstr = strcompress(string('Y1', n_elements(y1), format=arrel))
	    message, /inform, /noprefix, mstr(0)
	    message, /inform, /noprefix, /noname, mstr(1)
	    return
	endif
	if (n_elements(x2) ne 1) then begin
	    mstr = strcompress(string('X2', n_elements(x2), format=arrel))
	    message, /inform, /noprefix, mstr(0)
	    message, /inform, /noprefix, /noname, mstr(1)
	    return
	endif
	if (n_elements(y2) ne 1) then begin
	    mstr = strcompress(string('Y2', n_elements(y2), format=arrel))
	    message, /inform, /noprefix, mstr(0)
	    message, /inform, /noprefix, /noname, mstr(1)
	    return
	endif
	rmax = max([x1,y1,x2,y2], min=rmin)
	if (rmax gt 1 or rmin lt 0) then begin
	    mstr = strcompress(string(rmax, rmin, format=range))
	    message, /inform, /noprefix, mstr
	    return
	endif
	plot_zone = {plot_zone, corner:[x1,y1], size:[x2-x1,y2-y1]}
    end
    (n_params() eq 1 and n_elements(x1) eq 4): begin	; Array passed.
	rmax = max(x1, min=rmin)
	if (rmax gt 1 or rmin lt 0) then begin
	    mstr = strcompress(string(rmax, rmin, format=range))
	    message, /inform, /noprefix, mstr
	    return
	endif
	plot_zone = {plot_zone, corner:x1(0:1), size:x1(2:3)-x1(0:1)}
    end
    (1): begin				; Invalid
	mstr = strcompress(string(n_params(), n_elements(x1), format=badargs))
	message, /inform, /noprefix, mstr(0)
	message, /inform, /noprefix, /noname, mstr(1)
    end
endcase

return
end
