pro set_dir, data_dir, plot_dir = plot_dir

;+
; SET_DIR
;	Choose the directories to be used 	(a) to read the data and
;						(b) to put any hard copy plots
;
; Call:
;	set_dir[, data_dir, plot_dir]
;
; Argument:
;	data_dir	string	input	the directory where the data should be
;					sought
;
; Keyword:
;	plot_dir	string	input	The directory where plot files will be
;					written.
;
; History:
;	Spun off: 6/2/91; SJT
;	Unified version: 3/9/91; SJT
;	Remove prompt for plot_dir when only data_dir is given: 11/9/91; SJT
;-

@directories

if (n_params() ne 0) then dir = data_dir $ 
else begin
    if (n_elements(dir) eq 0) then cd, current=dir

    ddir = ''
    read, 'Enter directory with data files <'+dir+'> :_', ddir
    if ddir ne '' then dir = ddir
endelse

if (keyword_set(plot_dir)) then pldir = plot_dir $
else begin
    if (n_elements(pldir) eq 0) then pldir = dir
    if (n_params() eq 0) then begin
        ddir = ''
        read, 'Enter directory for plot files <'+pldir+'> :_', ddir
        if ddir ne '' then pldir = ddir
    endif
endelse

;	If vms we must translate the logical for the directory out to its end,
;	otherwise the make_fname procedure won't work properly.

if (!version.os eq 'vms') then repeat itr = trnlog(dir,dir) $
			       until itr mod 2 eq 0
	
return
end
