pro set_bg_thresh, thresh

;+
; SET_BG_THRESH
;	Set cut off level for background subtracted plots.
;
; Usage:
;	set_bg_thresh[, thresh]
;
; Argument:
;	thresh	float	input	The threshold level to use.
;
; History:
;	Extracted from SET_BACK: 18/11/93; SJT
;-

@bg_para
@settings
@flags
@spec_flags
@pad_flags

if (n_elements(bg_subtract) eq 0) then bg_subtract = 0
if (n_elements(bg_flag) eq 0) then bg_flag = 0

if (n_params() eq 1) then begin
    bg_thresh = thresh
    if (bg_subtract) then begin
	if (bg_flag) then replot_ok = 0
	spc_replot_ok = 0
	pad_replot_ok = 0
    endif

endif else begin
    if (n_elements(bg_thresh) eq 0) then bg_thresh = 2.
    dt = string(bg_thresh, format="(f6.2)")
    st = ''
    read, "Cutoff threshold for data (sigma above bg) <"+dt+"> :_", st
    if (st ne "") then begin
	bg_thresh = float(st)
        if (bg_subtract) then begin
	    if (bg_flag) then replot_ok = 0
	    spc_replot_ok = 0
	    pad_replot_ok = 0
        endif
    endif
endelse

end
