pro set_back,	pre_switch=pre_switch, $
		post_switch=post_switch, $
		lems30 = lems30, $
		lefs60 = lefs60, $
		lems120 = lems120, $
		lefs150 = lefs150, $
		ca60 = ca60, $
		wartb = wartb, $
		singles=singles, $
		changeover = changeover, $
		restore = restore

;+
; SET_BACK
;	Modify the instrument background levels.
;
; Usage:
;	set_back[, /pre_switch, /post_switch, $
;		  lems30=lems30, lefs60=lefs60, lems120=lems120, $
;		  lefs150=lefs150, ca60=ca60, wartb=wartb, $
;		  singles=singles, changeover=changeover, $
;		  threshold=threshold, /restore]
;
; Keywords:
;	pre_switch	input	if set then set the pre-jupiter
;				encounter backgrounds.
;	post_switch	input	if set then set the post
;				jupiter-encounter backgrounds.
;	lems30	float	input	The values for the LEMS30 (P)
;				backgrounds
;	lefs60	float	input	The values for the LEFS60 (E' and FP')
;				backgrounds
;	lems120	float	input	The LEMS120 (P') backgrounds.
;	lefs150	float	input	The LEFS150 (E and FP) backgrounds
;	ca60	float	input	The CA60 (W and Z) backgrounds
;	wartb	float	input	The backgrounds for the Wartb (DE)
;				channels.
;	singles	float	input	The background for the singles rates.
;	changeover int	input	The time (ydhms) at which the
;				changeover from pre- to post- switch
;				levels is to occur.
;	restore		input	If set then restore default (IDF) values.
;
; Restrictions:
;	Only one set of levels may be set at any one call (i.e.
;		post_ecounter or pre-switch).
;	If a head or heads is selected by keys then, (a) the correct
;		number of values must be given and (b) only those heads
;		are modified.
;	Restore key overrides all others.
;
; History:
;	Original: 10/9/93; SJT
;	Added restore key: 13/9/93; SJT
;	Added threshold key: 14/10/93; SJT
;	Change bg names to _bgc(d) from _c(d): 5/11/93; SJT
;	Moved threshold setting out to set_bg_thresh.pro: 18/11/93; SJT
;-

@bg_para
@settings
@flags
@pad_flags
@spec_flags

;	Give flags values if need be

if (n_elements(bg_subtract) eq 0) then bg_subtract = 0
if (n_elements(bg_flag) eq 0) then bg_flag = 0

if (keyword_set(restore)) then begin
    f1_bgc = f1_bgcd
    f2_bgc = f2_bgcd
    m1_bgc = m1_bgcd
    m2_bgc = m2_bgcd
    d_bgc  = d_bgcd
    w_bgc  = w_bgcd
    z_bgc  = z_bgcd
    s_bgc = s_bgcd
    bgc_time = bgc_timed
    if (bg_subtract) then begin
	if (bg_flag) then replot_ok = 0
	spc_replot_ok = 0
	pad_replot_ok = 0
    endif
    return
endif

;	Establish whether we are setting pre-switch of post
;	switch levels.

if (keyword_set(pre_switch) and keyword_set(post_switch)) then begin
    hs_err_msg, $
	"**** ERROR **** Pre_switch and Post_switch keys are exclusive"
    return
endif else if (keyword_set(pre_switch))  then pre_post = 0 $
else       if (keyword_set(post_switch)) then pre_post = 1 $
else begin
    ba = ''
getpp:
    read, "Set backgrounds Before or After level change (B/A) :_", ba
    case strupcase(ba) of
	'A': pre_post = 1
	'B': pre_post = 0
	else: goto, getpp
    endcase
endelse

;	Check whether values have been set by keyword.

n_head = keyword_set(lems30) + keyword_set(lefs60) + $
	 keyword_set(lems120) + keyword_set(lefs150) + $
	 keyword_set(ca60) + keyword_set(wartb) + $
	 keyword_set(singles)

;	No values set, interactive setting.

if (n_head eq 0) then begin
    heads = ['LEMS30', 'LEFS60', 'LEMS120',' LEFS150', $
	     'CA60', 'WARTB', 'Singles']

    channm = [	['P'+strtrim(sar(8),2), strarr(4)], $
		["E"+strtrim(sar(4),2)+"'", $
			"FP"+strtrim(sar(5,7),2)+"'", strarr(5)], $
		['P'+strtrim(sar(8),2)+"'", strarr(4) ], $
		["E"+strtrim(sar(4),2), "FP"+strtrim(sar(5,7),2), $
			strarr(5)], $
		["W"+strtrim(sar(8),2), "Z2", "Z2A", "Z3", "Z4"], $
		["DE"+strtrim(sar(4),2), strarr(8)], $
		["B", "C", "D", "M", "F", "M'", "F'", strarr(5)]]
    nch = [8, 7, 8, 7, 12, 4, 7]

    for ihd = 0, n_elements(heads)-1 do begin
	iwant = ''
gethd:
	read, 'Do you want to modify backgrounds for '+heads(ihd)+ $
		' (y/n) :_', iwant
        iwant = strlowcase(iwant)
	if (iwant eq 'y') then begin
	    case (ihd) of
		0: bgd = m2_bgc(*,pre_post)
		1: bgd = f1_bgc(*,pre_post)
		2: bgd = m1_bgc(*,pre_post)
		3: bgd = f2_bgc(*,pre_post)
		4: bgd = [w_bgc(*,pre_post),z_bgc(*,pre_post)]
		5: bgd = d_bgc(*,pre_post)
		6: bgd = s_bgc(*,pre_post)
	    endcase

	    bgl = fltarr(nch(ihd))
	    for j = 0, nch(ihd)-1 do begin
		cbg = ''
		read, "Background for "+channm(j,ihd)+" <"+$
			string(bgd(j))+"> :_", cbg
		if (cbg ne '') then bgl(j) = float(cbg) $
		else		    bgl(j) = bgd(j)
	    endfor

	    case (ihd) of
		0: m2_bgc(*,pre_post) = bgl
		1: f1_bgc(*,pre_post) = bgl
		2: m1_bgc(*,pre_post) = bgl
		3: f2_bgc(*,pre_post) = bgl
		4: begin
		    w_bgc(*,pre_post) = bgl(0:7)
		    z_bgc(*,pre_post) = bgl(8:*)
		end
		5: d_bgc(*,pre_post) = bgl
		6: s_bgc(*,pre_post) = bgl
	    endcase
            if (bg_subtract) then begin
	        if (bg_flag) then replot_ok = 0
		spc_replot_ok = 0
		pad_replot_ok = 0
	    endif
	endif else if (iwant ne 'n') then goto, gethd
    endfor
endif else begin

    if (keyword_set(lems30))  then m2_bgc(*,pre_post) = lems30
    if (keyword_set(lefs60))  then f1_bgc(*,pre_post) = lefs60
    if (keyword_set(lems120)) then m1_bgc(*,pre_post) = lems120
    if (keyword_set(lefs150)) then f2_bgc(*,pre_post) = lefs150
    if (keyword_set(wartb))   then d_bgc(*,pre_post)  = wartb
    if (keyword_set(singles)) then s_bgc(*,pre_post)  = singles
    if (keyword_set(ca60))    then begin
	w_bgc(*,pre_post) = ca60(0:7)
	z_bgc(*,pre_post) = ca60(8:*)
    endif
    if (bg_subtract) then begin
	if (bg_flag) then replot_ok = 0
	spc_replot_ok = 0
	pad_replot_ok = 0
    endif
endelse

if (keyword_set(changeover)) then begin
    bgc_time=changeover
    if (bg_subtract) then begin
	if (bg_flag) then replot_ok = 0
	spc_replot_ok = 0
	pad_replot_ok = 0
    endif
endif else begin
    if (n_elements(bgc_time) eq 0) then bgc_time = intarr(4)
 
    dt = string(bgc_time, format="(i4,i4.3,3i3.2)")
    st = ''
    read, "Time of background level change <"+dt+"> :_", st
    if (st ne "") then begin
	bgc_time=conv_time_str(st)
        if (bg_subtract) then begin
	    if (bg_flag) then replot_ok = 0
	    spc_replot_ok = 0
	    pad_replot_ok = 0
        endif
    endif
endelse

bg_present = 1

end
