pro save_plot, file, cursor=cursor, gif=gif
;+
;  SAVE_PLOT
;	Reads a plot from the device, and saves it to an HDF file.
;	If the file already contains images, then the plot is appended to the
;	end of the file. If the device does not support readin an image, then
;	an error message will be issued and the proc will return.
;
;  Arguments:
;	file	string	input	The name of the HDF file to write to.
;
;  Keyword:
;	cursor	undef	input	If set (and non-zero) then the library
;				routine BOX_CURSOR is used to interactively 
;				define the region to save.
;	gif	undef	input	If set, then save as a GIF file rather
;				than HDF
;
;  History:
;	prototype: 31/7/91; SJT
;	Add cursor keyword: 20/8/91; SJT
;	Write to /read from plot directory if defined: 5/2/92; SJT
;	Separated out: 27/11/92; SJT
;	Restored to save_plot to use V3 builtin HDF: 29/11/93; SJT
;	Add GIF option: 22/11/94
;-

@directories

if (fix(!version.release) lt 3 and not keyword_set(gif)) then begin
    hs_err_msg, ["SHOW_HDF now uses the internal IDL HDF calls", $
		 "this needs version 3.0.0 or higher, you have "+ $
			!version.release]
    return
end

if (!d.flags and 128) eq 0 then begin
    hs_err_msg, 'Device does not support reading of pixels.'
    return
endif

if n_params() eq 0 then begin
    file = ''
    sftype = (['HDF', 'GIF'])(keyword_set(gif))
    read, 'Name of '+sftype+' file? :_', file
endif

if (n_elements(pldir) ne 0) and (strpos(file, '/') eq -1 and $
	strpos(file, ':') eq -1 and strpos(file, ']') eq -1) then $
		fsav = form_fname(file, pldir) $
else fsav = file


if keyword_set(cursor) then begin
    box_cursor, x0, y0, nx, ny, /mess
endif else begin			; Whole visible portion.
    x0 = 0
    y0 = 0
    nx = !d.x_vsize
    ny = !d.y_vsize
endelse

;	Get the colour table in the form which HDF likes.

hs_err_msg, 'Getting colour table...'
pal = bytarr(3,256)
r = bytarr(!d.n_colors)
g = bytarr(!d.n_colors)
b = bytarr(!d.n_colors)

tvlct, /get, r,g,b
pal(0,0:!d.n_colors-1) = r
pal(1,0:!d.n_colors-1) = g
pal(2,0:!d.n_colors-1) = b

;	Read the image from the screen

hs_err_msg, 'Getting image...'

if (keyword_set(gif)) then odr = 0  $
else odr = 1

image = tvrd(x0, y0, nx, ny, order = odr)

;	Check whether the output file is HDF, and if so whether it contains
;	any images.

if (keyword_set(gif)) then begin
    hs_err_msg, 'Writing image...'
    write_gif, fsav, image, r, g, b
    
endif else begin
    hs_err_msg, 'Checking output file...'
    if (hdf_ishdf(fsav)) then begin ; HDF file.
        nin = dfr8_nimages(fsav)
    endif else nin = 0          ; Not HDF - assume non-existent

;	Set the palette and write the image.

    hs_err_msg, 'Writing image...'
    dfr8_setpalette, pal
    
    if nin eq 0 then dfr8_putimage, fsav, image, /rle $
    else	     dfr8_addimage, fsav, image, /rle
endelse

hs_err_msg, 'Done.'

end
