pro save_all, file, verbose = verbose, xdr = xdr

;+
;  SAVE_ALL
;	Save complete PLOT_RATES and PLOT\_CDF environment, so that it can 
;	be restored later by using GET_ALL.
;
;  Usage:
;	save_all [, file]
;
;  Argument:
;	file	string	input	Optional filename for save.
;
;  Keyword:
;	verbose		if set and non-zero, then print information on save.
;	xdr		if set and non-zero, then use XDR save - irrelevant
;			for UNIX systems.
;
;  History:
;	Initial version derived from SAVE_OPTIONS: 27/9/91; SJT
;	Added CDF common blocks: 18/9/91; SJT
;	Added movie common blocks: 21/11/91; SJT
;	Write to /read from plot directory if defined: 5/2/92; SJT
;	Add spectrum common blocks: 5/3/92; SJT
;	Added PAD common blocks: 23/4/92; SJT
;	Add commons for PLOT_MAG: 28/4/92; SJT
;	Updated common list: 19/1/93; SJT
;	Ditto: 22/6/94; SJT
;	Added UDS commons: 4/11/94; SJT
;-

@accumbuf
@axis_limits
@b_axis_limits
@b_data_arrays
@b_flags
@b_movie
@b_settings
@bg_para
@cdf_arrays
@cdf_chans
@cdf_flags
@chansets
@chlist
@data_arrays
@dcs
@directories
@duty_cycles
@energy_label
@energy_mfsa
@energy_para
@err_info
@file_info
@filtering
@flags
@frampar
@m_animate
@m_pl_tfm
@mov_trace
@movie_colour
@movie_energy
@movie_set
@need_sav
@pad_flags
@pad_names
@pad_sect_orient
@pad_set
@plot_reg
@plot_settings
@s_axis_limits
@s_data_arrays
@sect_list
@settings
@spc_title
@spec_flags
@spec_settings
@spool_action
@time_limits
@track_bins
@trk_energies
@versions
@wid_fonts
@cospin_pars
@epacs_pars
@hiscale_pars
@swics_pars
@uds_arrays
@uds_chans
@uds_flags
@raw_ephem
@colour_tab
@trk_maps
@pha_set
@pha_flags
@pha_arrays

if (n_params() eq 0) then begin
    file = ''
    read, 'File to which to save settings :_', file
endif

if (n_elements(pldir) ne 0) and (strpos(file, '/') eq -1 and $
	strpos(file, ':') eq -1 and strpos(file, ']') eq -1) then $
		fsav = form_fname(file, pldir) $
else fsav = file

if (n_elements(pha_ndata) ne 0) then begin
    pulses = fltarr(256, 256, pha_ndata+1)
    for j = 0l, pha_ndata do begin
        handle_value, pha_matrices(j), pss, /no_copy
        pulses(pss.places+j*long(256)^2) = pss.counts
        handle_value, pha_matrices(j), pss, /no_copy, /set
    endfor
endif

save, /variables, verbose=keyword_set(verbose), file=fsav, $
		xdr = keyword_set(xdr)

end
