;+
; S_PLOT_MENU
;	Widget interface for SAVE_PLOT
;
; Usage:
;	s_plot_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 19/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Safety net against reading from empty strings: 23/6/93; SJT
;	Force scrolling if the base is to big: 21/4/94; SJT
;	Add GIF option: 22/11/94; SJT
;	Allow GIF-mode for V2.x: 25/11/94; SJT
;-

pro s_plot_event, event

;	The event handler

@directories
@s_plot_wid

widget_control, event.id, get_uvalue=but

case but of

;	Exits

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
	widget_control, sselfile, get_value=sfile
        if (max(strlen(strcompress(sfile, /remove))) gt 0) then begin
	    widget_control, event.top, /destroy, /hourglass
	    save_plot, sfile(0),  cursor=icurs, gif = igif
	endif else hs_err_msg, 'Must give a save file name'
	return
    end

;	Directories

    'DAT': widget_control, sselfile, set_value=dir
    'PLO': widget_control, sselfile, set_value=pldir
    'CUR': widget_control, sselfile, set_value=currdir
    'NOSAVE': widget_control, sselfile, set_value=''

;	Modes

    'CURS': icurs = event.select
    'GIF': igif = event.select
    
;	The save string (ignore)

    else:
endcase

end

pro s_plot_menu, group=group

;	Menu maker

@directories
@s_plot_wid
@wid_fonts
@wid_set

if (xregistered('s_plot')) then return	; Don't make a second copy.

if (fix(!version.release) lt 3) then begin
    hs_err_msg, ["SHOW_HDF now uses the internal IDL HDF calls", $
		 "this needs version 3.0.0 or higher, you have "+ $
			!version.release]
    return
end

;	Output file things

dirch = ['Data', 'Plot', 'Current', 'Clear']
udirc = ['DAT', 'PLO', 'CUR', 'NOSAVE']
dirchse = [n_elements(dir) ne 0, n_elements(pldir) ne 0, 1, 1]

cd, current= currdir
if (n_elements(pldir) ne 0) then sfdir = pldir $
else				 sfdir = currdir
sffile = ''

;	Format control (remember gif/hdf state, but not cursor
;	selection state) HDF not available in IDL 2.x.

icurs = 0
if (N_elements(igif) eq 0) then igif = 0
if (float(!Version.release) lt 3.0) then begin
    igif = 1
    ichtype = 0
endif else ichtype = 1

;	Base widgets

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'SAVE_PLOT', xpad = 5, $
                                     ypad = 5, /column, $
                                     /scroll, x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(title = 'SAVE_PLOT', xpad = 5, ypad = 5, /column)

txt = widget_label(base, value = 'Save plot as HDF or GIF file', frame = 2, $
                   font = large_v)


;	The file name

savebase = widget_base(base, /column, /frame)
junk = widget_label(savebase, value='HDF/GIF file selection', font=normal_v)

jb = widget_base(savebase, /column)
sselfile = widget_text(jb, /edit, /frame, val=sffile, xsize=50, $
	ysize=1, uvalue='SAVEFILE', font=normal_f)
xmenu, dirch, jb, uvalue = udirc, buttons = bid, /row, font = normal_v
for i = 0, n_elements(dirch)-1 do $
	widget_control, bid(i), sensitive=dirchse(i)

;	Save mode

jb = widget_base(base, /column, /frame)
junk = widget_label(jb, value='Save option selection', font=normal_v)
jb1 = widget_base(jb, /row)
jb2 = cw_tbutton(jb1, value = ['Whole window', 'Use Cursor'],  $
                 uvalue = 'CURS', font = normal_v, state = icurs)
if (ichtype eq 1) then $
  jb2 = cw_tbutton(jb1, value = ['HDF Format', 'GIF format'],  $
                   uvalue = 'GIF', font = normal_v, state = igif) $
else $
  jb2 = widget_label(jb1, value = 'GIF format only', font = normal_v)

;	Exit buttons

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)

;	realize

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

widget_control, sselfile,  /input_focus
xmanager, 's_plot', base, group=group

end
