;+
; S_HDF_MENU
;	Widget interface for SHOW_HDF
;
; Usage:
;	s_hdf_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 19/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Force scrolling if the base is to big: 21/4/94; SJT
;-

pro s_hdf_event, event

;	Event handler

@s_hdf_wid
@time_limits
@directories
@plot_settings

widget_control, event.id, get_uvalue=but

case but of
;	Exits

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
	widget_control, event.top, /destroy, /hourglass
	if (iprog) then show_hdf, program=prog $
	else		show_hdf, hdfname
	return
    end

;	Main mode of operation

    'PROGS': begin
	iprog = event.select
	if (iprog) then begin
	    widget_control, chbases(0), map=0
	    widget_control, chbases(1), /map
	    if (n_elements(tstart) gt 0 and $
		n_elements(dir) gt 0 and $
		n_elements(pldname) gt 0) then $
			widget_control, dobut, /sensitive $
	    else	widget_control, dobut, sensitive=0
	endif else begin
	    widget_control, chbases(1), map=0
	    widget_control, chbases(0), /map
	    if (hdfname ne '' and $
		n_elements(dir) gt 0 and $
		n_elements(pldname) gt 0) then $
			widget_control, dobut, /sensitive $
	    else	widget_control, dobut, sensitive=0
	endelse
    end
;		Key settings

    'Directories': begin
	dir_menu, group=event.top
	if (iprog) then begin
	    if (n_elements(tstart) gt 0 and $
		n_elements(pldname) gt 0) then $
			widget_control, dobut, /sensitive
	endif
	for i = 0, 1 do widget_control, dirmen(i), /sensitive
    end

    'Time Limits': begin
	time_menu, group=event.top
	if (n_elements(dir) gt 0 and $
	    n_elements(pldname) gt 0) then $
			widget_control, dobut, /sensitive
    end

    'Plot Device': begin
	plot_menu, group=event.top
	if (iprog) then begin
	    if (n_elements(tstart) gt 0 and $
		n_elements(dir) gt 0) then $
			widget_control, dobut, /sensitive
	endif else begin
	    if (hdfname ne '') then widget_control, dobut, /sensitive
	endelse
    end

;	File picker items

    'DIR': begin
	widget_control, dirtxt, get_value=txt
	hdfdir = txt(0)
	sp = form_fname(hdffilt, hdfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	hdfname = ''
	widget_control, selfile, set_value=hdfname
	widget_control, dobut, sensitive = 0
	widget_control, filttxt, /input_focus
    end

    'FILT': begin
	widget_control, filttxt, get_value=txt
	hdffilt = txt(0)
	sp = form_fname(hdffilt, hdfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	hdfname = ''
	widget_control, selfile, set_value=hdfname
	widget_control, dobut, sensitive = 0
	widget_control, dirtxt, /input_focus
    end

    'DAT': begin
	widget_control, dirtxt, set_value=dir
	hdfdir = dir
	sp = form_fname(hdffilt, hdfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	hdfname = ''
	widget_control, selfile, set_value=hdfname
	widget_control, dobut, sensitive = 0
	widget_control, filttxt, /input_focus
    end

    'PLO': begin
	widget_control, dirtxt, set_value=pldir
	hdfdir = pldir
	sp = form_fname(hdffilt, hdfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	hdfname = ''
	widget_control, selfile, set_value=hdfname
	widget_control, dobut, sensitive = 0
	widget_control, filttxt, /input_focus
    end

    'CUR': begin
	widget_control, dirtxt, set_value=currdir
	hdfdir = currdir
	sp = form_fname(hdffilt, hdfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	hdfname = ''
	widget_control, selfile, set_value=hdfname
	widget_control, dobut, sensitive = 0
	widget_control, filttxt, /input_focus
    end

;	File selection

    'SELECT': begin
	hdfname = flist(event.index)
	widget_control, selfile, set_value=hdfname
	if (n_elements(pldname) gt 0) then widget_control, dobut, /sensitive
    end

;	Selection of programs (anything else)

    else: prog = but
endcase
end

pro s_hdf_menu, group=group

;	Menu maker

@s_hdf_wid
@time_limits
@directories
@plot_settings
@wid_fonts
@wid_set

if (xregistered('s_hdf')) then return	; Don't make a second copy.

if (fix(!version.release) lt 3) then begin
    hs_err_msg, ["SHOW_HDF now uses the internal IDL HDF calls", $
		 "this needs version 3.0.0 or higher, you have "+ $
			!version.release]
    return
end

progs = ['LANSPECT', 'LAN360', 'SEEPHA', 'SEEMFSA', 'SPECPLOT', $
	'SPECTIME', 'COMP']
if (n_elements(prog) eq 0) then prog = progs(0)
if (n_elements(iprog) eq 0) then iprog = 0

;	Explicit file things

dirch = ['Data', 'Plot', 'Current', 'Apply']
udirc = ['DAT', 'PLO', 'CUR', 'DIR']
dirchse = [n_elements(dir) ne 0, n_elements(pldir) ne 0, 1, 1]

cd, current= currdir
if (n_elements(pldir) ne 0) then begin
    hdfdir = pldir
endif else begin
    hdfdir = currdir
endelse

hdffilt = '*.hdf'

;	Main level base:

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'SHOW_HDF', xpad = 5, $
                                     ypad = 5, /column, $
                                     /scroll, x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(title = 'SHOW_HDF', xpad = 5, ypad = 5, $
                        /column)

txt = widget_label(base, value='HDF file display', frame=2, font=large_v)

;	Whether to pick explictly or from programs

jb = widget_base(base, /row, /frame)
junk = widget_label(jb, value = 'APL/ATT Programs or explicit file:', $
                    font = normal_v)
jb1 = cw_tbutton(jb, value = ['Explicit', 'APL/ATT'], uvalue = 'PROGS', $
                 font = normal_v, state = iprog)

;	Alternate bases for the two possibilities above

chbases = lonarr(2)
jb = widget_base(base)
for i = 0, 1 do chbases(i) = widget_base(jb, /column)

;	The explicit file base (chbases(0))

;	Required settings

reqs = ['Directories', 'Plot Device']
rqb = widget_base(chbases(0), /column, /frame)
junk = widget_label(rqb, value='Required Settings', font=normal_v)
xmenu, reqs, rqb, uvalue=reqs, /row, font=normal_v

;	The file chooser

pickbase = widget_base(chbases(0), /column, /frame)
junk = widget_label(pickbase, value='Input file selection', font=large_v)

jb = widget_base(pickbase, /column, /frame)
dirbase = widget_base(/row, jb)
dirlab = widget_label(dirbase, val='Directory', font=normal_v)
dirtxt = widget_text (/edit, dirbase, value=hdfdir, uval='DIR', $
	xsize=40, ysize=1, /frame, font=normal_f)
xmenu, dirch, jb, uvalue = udirc, buttons = dirmen, /row, font = $
  normal_v
for i = 0, n_elements(dirch)-1 do $
	widget_control, dirmen(i), sensitive=dirchse(i)

jb = widget_base(pickbase, /column, /frame)
filtbase = widget_base(/row, jb)
filtlab = widget_label(filtbase, val='Filter', font=normal_v)
filttxt = widget_text(/edit, filtbase, value=hdffilt, uval='FILT', $
	xsize=40, ysize=1, /frame, font=normal_v)
junk = widget_button(jb, value='Apply', uvalue='FILT', font=normal_v)

selbase = widget_base(/column, /frame, pickbase)
sellab = widget_label(selbase, val='File Selection Menu', font=normal_v)
sp = form_fname(hdffilt, hdfdir)
flist = findfile(sp)
selmenu = widget_list(selbase, val=flist, uval='SELECT', $
	ysize=6, /frame, font=normal_f)

hdfname =''
sellab2 = widget_label(selbase, val='Selected File', font=normal_v)
selfile = widget_text(selbase, /frame, val=hdfname, xsize=50, $
		ysize=1, font=normal_f)

;	Specific program output. (chbases(1))

;	Required settings

reqs = ['Directories', 'Time Limits', 'Plot Device']
rqb = widget_base(chbases(1), /column, /frame)
junk = widget_label(rqb, value='Required Settings', font=normal_v)
xmenu, reqs, rqb, uvalue=reqs, /row, font=normal_v

;	The menu for the program

jb = widget_base(chbases(1), /column, /frame)
junk = widget_label(jb, value='Program Selection', font=large_v)
xmenu, progs, jb, font=normal_v, $
	/exclusive, row=2, uvalue=progs, /no_release, button=bid
nprog = (where(prog eq progs))(0)
widget_control, bid(nprog), /set_button

;	Choose which to map

if (iprog) then begin
    widget_control, chbases(0), map=0
    widget_control, chbases(1), /map
endif else begin
    widget_control, chbases(1), map=0
    widget_control, chbases(0), /map
endelse

; exit options

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)

if (not iprog) then widget_control, dobut, sensitive=0 $
else if (n_elements(pldname) eq 0 or n_elements(tstart) eq 0 or $
	n_elements(dir) eq 0) then widget_control, dobut, sensitive=0


widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif


widget_control, dirtxt, /input_focus
xmanager, 's_hdf', base, group=group

end
