;+
; S_ALL_MENU
;	Widget interface for SAVE_ALL/OPTIONS
;
; Usage:
;	s_all_menu[, /options]
;
; Arguments: none
;
; Keywords:
;	options			If set and non_zero, then save_options
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 19/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Safety net against reading from empty strings: 23/6/93; SJT
;	Force scrolling if the base is to big: 21/4/94; SJT
;-

pro s_all_event, event

;	The event handler

@directories
@s_all_wid

widget_control, event.id, get_uvalue=but

case but of

;	Exits

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
	widget_control, sselfile, get_value=sfile
        if (max(strlen(strcompress(sfile, /remove))) gt 0) then begin
	    widget_control, event.top, /destroy
	    if (iopts) then save_options, sfile(0),  xdr=xdrm, verbose=verb $
	    else 	    save_all, sfile(0),  xdr=xdrm, verbose=verb
	endif else hs_err_msg, 'Must give a save file name'
	return
    end

;	Directories

    'DAT': widget_control, sselfile, set_value=dir
    'PLO': widget_control, sselfile, set_value=pldir
    'CUR': widget_control, sselfile, set_value=currdir
    'NOSAVE': widget_control, sselfile, set_value=''

;	Modes

    'VERB': verb = event.select
    'XDR': xdrm = event.select

;	The save string (ignore)

    else:
endcase

end

pro s_all_menu, options = options, group=group

;	Menu maker

@directories
@s_all_wid
@wid_fonts
@wid_set

if (xregistered('s_all')) then return	; Don't make a second copy.

;	Which mode

if (keyword_set(options)) then	iopts = 1 $
else				iopts = 0

;	Output file things

dirch = ['Data', 'Plot', 'Current', 'Clear']
udirc = ['DAT', 'PLO', 'CUR', 'NOSAVE']
dirchse = [n_elements(dir) ne 0, n_elements(pldir) ne 0, 1, 1]

cd, current= currdir
if (n_elements(pldir) ne 0) then sfdir = pldir $
else				 sfdir = currdir
sffile = ''

;	Format control

xdrm = 0
verb = 0

;	Base widgets

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'SAVE_ALL/OPTIONS', xpad $
                                     = 5, ypad = 5, $
                                     /column, /scroll, x_scroll_size = $
                                     xss, y_scroll_size = yss) $
else base = widget_base(title = 'SAVE_ALL/OPTIONS', xpad = 5, ypad = $
                        5, /column)

if (iopts) then txt = widget_label(base, $
		value='Save options variables', frame=2, font=large_v) $
else txt = widget_label(base, value='Save all common variables', $
		frame=2, font=large_v)

;	The file name

savebase = widget_base(base, /column, /frame)
junk = widget_label(savebase, value='Save file selection', font=normal_v)

jb = widget_base(savebase, /column)
sselfile = widget_text(jb, /edit, /frame, val=sffile, xsize=50, $
	ysize=1, uvalue='SAVEFILE', font=normal_f)
xmenu, dirch, jb, uvalue = udirc, buttons = bid, /row, font = normal_v
for i = 0, n_elements(dirch)-1 do $
	widget_control, bid(i), sensitive=dirchse(i)

;	Save mode

jb = widget_base(base, column = (!Version.os eq 'vms'), row = $
                 (!Version.os ne 'vms'), /frame)
junk = widget_label(jb, value='Save option selection', font=normal_v)
jb1 = widget_base(jb, /row)

jb2 = cw_tbutton(jb1, value = ['Quiet', 'Verbose'], uvalue = 'VERB', $
                font = normal_v, state = verb)

;	XDR mode for VMS only

if (!Version.os eq 'vms') then $
  jb2 = cw_tbutton(jb1, value = ['VMS Format', 'XDR Format'], uvalue = $
                   'XDR', font = normal_v, state = xdrm)

;	Exit buttons

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)

;	realize

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif


widget_control, sselfile, /input_focus
xmanager, 's_all', base, group=group

end
