;+
; REGION_MENU
;	Set plotting region.
;
; Call:
;	region_menu
;
; Keywords:
;	group	long	input	Group leader of the hierarchy.
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original, extracted from PLOT_MENU: 29/6/94; SJT
;-

pro Region_event, event

@plot_reg
@reg_wid

widget_control, event.id, get_uval=but


case but of
    
    'DONE': begin
        plot_zone.corner = reg_corn(0:1)
        plot_zone.size = reg_corn(2:3) - reg_corn(0:1)
        widget_control, event.top, /destroy
    end
    
    'CANCEL': widget_control, event.top, /destroy

    'RGLLX': begin
	widget_control, event.id, get_value=val
	reg_corn(0) = val
	if (reg_corn(0) gt reg_corn(2)) then begin
	    reg_corn(0) = reg_corn(2)
	    widget_control, event.id, set_value = reg_corn(0)
	endif
    end

    'RGLLY': begin
	widget_control, event.id, get_value=val
	reg_corn(1) = val
	if (reg_corn(1) gt reg_corn(3)) then begin
	    reg_corn(1) = reg_corn(3)
	    widget_control, event.id, set_value = reg_corn(1)
	endif
    end

    'RGURX': begin
	widget_control, event.id, get_value=val
	reg_corn(2) = val
	if (reg_corn(0) gt reg_corn(2)) then begin
	    reg_corn(2) = reg_corn(0)
	    widget_control, event.id, set_value = reg_corn(2)
	endif
    end

    'RGURY': begin
	widget_control, event.id, get_value=val
	reg_corn(3) = val
	if (reg_corn(1) gt reg_corn(3)) then begin
	    reg_corn(3) = reg_corn(1)
	    widget_control, event.id, set_value = reg_corn(3)
	endif
    end
    
endcase

end


pro Region_menu, group=group

@plot_reg
@reg_wid
@wid_fonts

if (xregistered('region')) then return ; Don't make second copy.

if (n_elements(plot_zone) eq 0) then $
  plot_zone = {plot_zone, corner:[0., 0.], size:[1., 1.]}
reg_corn = [plot_zone.corner, plot_zone.size + plot_zone.corner]

base = widget_base(/column, xpad = 5, ypad = 5, title $
                        = 'Plot Region')

txt = widget_label(base, frame=2, value='Plot Region Settings', font=large_v)

;	Plot region.

reglabs = lonarr(4)
rb1 = widget_base(base, /row)

rbl = widget_base(rb1, /column)
junk = widget_label(rbl, value='Lower left corner', font=normal_v)

rblx = widget_base(rbl, /row)
junk = widget_label(rblx, value='X', font=normal_v)
junk = cw_fslider(rblx, min = 0.0, max=1.0, value=reg_corn(0), $
	uvalue='RGLLX', format="(f4.2)")

rbly = widget_base(rbl, /row)
junk = widget_label(rbly, value='Y', font=normal_v)
junk = cw_fslider(rbly, min = 0.0, max=1.0, value=reg_corn(1), $
	uvalue='RGLLY', format="(f4.2)")

rbr = widget_base(rb1, /column)
junk = widget_label(rbr, value='Upper right corner', font=normal_v)

rbrx = widget_base(rbr, /row)
junk = widget_label(rbrx, value='X', font=normal_v)
junk = cw_fslider(rbrx, min = 0.0, max=1.0, value=reg_corn(2), $
	uvalue='RGURX', format="(f4.2)")

rbry = widget_base(rbr, /row)
junk = widget_label(rbry, value='Y', font=normal_v)
junk = cw_fslider(rbry, min = 0.0, max=1.0, value=reg_corn(3), $
	uvalue='RGURY', format="(f4.2)")

;	Cancel and do it buttons

dobase = widget_base(base, /row)
canbut = widget_button(dobase, value = 'Cancel', uvalue = 'CANCEL', $
                       font = normal_v)
dobut = widget_button(dobase, value = 'Do it', uvalue = 'DONE', font = $
                      normal_v)

;	Realize & register

widget_control, base, /real
xmanager, 'region', base, group = group

end
