function Read_scale_wid, wid, have_value, abstime=abstime, $
                         lower=lower, upper=upper

;+
; READ_SCALE_WID
;	Read a scaling limit from a text widget.
;
; Usage:
;	limit = read_scale_wid(wid, have_value[, /abstime])
;
; Return Value:
;	limit	float	The limit returned (0 if no value or error)
;
; Arguments:
;	wid	long	input	The widget ID of the widget to read.
;	have_value int	output	1 = got value, 0 = empty widget, -1 =
;				error
;
; Keywords:
;	abstime		input	If set, then treat the widget contents
;				as an absolute time.
;	lower		input	If set, and abstime is set, then check
;				that this is a sensible lower time limit.
;	upper		input	If set, and abstime is set, then check
;				that this is a sensible upper time limit.
;
; History:
;	Original (Out of SCALE_MENU): 16/12/94; SJT
;-

@time_limits

if (not widget_info(wid, /valid)) then begin
    hs_err_msg, "Not a valid widget ID"
    have_value = -1
    return, 0.
endif

if (n_elements(tstart) eq 0 and keyword_set(abstime)) then begin
    hs_err_msg, "Cannot handle absolute times with no limits set"
    have_value = -1
    return, 0.
endif

widget_control, wid, get_value = val

;	Empty box

if (max(strlen(strcompress(val, /remove))) eq 0) then begin
    have_value = 0
    return, 0.
endif

if keyword_set(abstime) then begin
    t = conv_time_str(val(0))
    if (keyword_set(lower)) then begin
        if (compare_times(tstop, t) eq -1) then begin
            hs_err_msg, ["Absolute start time out of range"]
            have_value = -1
            return, 0.
        endif
    endif else if (keyword_set(upper)) then begin
        if (compare_times(tstart, t) eq 1) then begin
            hs_err_msg, ["Absolute end time out of range"]
            have_value = -1
            return, 0.
        endif
    endif
    have_value = 1
    return, abs_rel(t)
endif

reads, val, limit
have_value = 1
return, limit

end
