pro plotset, nowindow=nowindow

;+
; PLOTSET
;	Sets up the device according to the choices made in PLOPEN.
;       Sets suitable colour table for line plots (PGPLOT default table).
;
; Call:
;       plotset
;
; Arguments: None
;
; Keywords: 
;	nowindow  ?	input	If set and non-zero, then don't explicitly 
;				create a window (used by (e.g.) show_hdf where
;				a size must be determined later.
;
; Common Blocks:
;       dcs             Sets a suitable character size to get at least 
;                       80 chars/line.
;       plot_reg        size is used in computing the above.
;
; History:
;       Made to procedure: 28/1/91; SJT
;       common block DCS to hand charsize around added: 1/2/91; SJT
;       Added common plot_reg, to set plot region: 5/2/91; SJT
;       Clean up backgound prompt: 22/2/91; SJT
;       Choose filename, suitable background default: 12/3/91; SJT
;       Support for various specialized TEK emulators added: 27/3/91; SJT
;       Support for sizing of window on windowing systems: 15/4/91; SJT
;       LJ250 specific option setting added (for V2.0.13): 3/5/91; SJT
;       Select hardware font in PostScript: 10/5/91; SJT
;       Remember orientation, fix portrait mode size in PS: 17/7/91; SJT
;       Major tidy up - code had turned into spaghetti: 17/7/91; SJT
;	For screen devices - read colour table to decide bg colour: 2/8/91; SJT
;	Unified version with arguments and keywords: 3/9/91; SJT
;	Dissected out from plopen: 9/10/91; SJT
;	Add PS TeX options: 18/11/91; SJT
;	BW PS device call fixed: 31/12/91; SJT
;	Support for TEK output to a file: 7/1/92; SJT
;	Remove cd (replace with form_fname): 4/2/92; SJT
;	Set IDI char size, switch LJ to high res: 6/2/92; SJT
;	Add support for multiple windows: 20/2/92; SJT
;	Add keyword nowindow: 6/8/92; SJT
;	Modifications to cope better with monochrome X-terminals: 7/8/92; SJT
;	Change to use server supplied backing store for X: 28/8/92; SJT
;	Add use of devname for widgets: 7/1/93; SJT
;	Force unique filenames in unix: 17/2/93; SJT
;	Clear multiplots (!p.multi): 2/7/93; SJT
;	Separate page size and window size: 20/4/94; SJT
;	Add LN03 "Pseudo-device": 28/7/94;SJT
;	Make colour tables common: 12/1/95; SJT
;	Remove background setting from colour hardcopy devices:
;	25/7/95; SJT
;	Add HI-SCALE/EPAM ID message: 13/11/97; SJT
;-

@plot_reg
@dcs
@plot_settings
@directories
@colour_tab
@versions

!P.font = -1                    ; Software fonts (changed for PS)
!P.multi = 0                    ; Clear multiplots, these will
                                ; be overridden by the explicit
                                ; positioning and will screw up
                                ; char sizes.
!P.position = 0                 ; Clear position & region
!P.region = 0                   ; to prevent confusion.

if (n_elements(plotfile) eq 0) then plotfile = ''
if (n_elements(need_new_window) eq 0) then need_new_window = 1

set_plot, devname

case pldname of
    't5': begin                         ; Cifer T5 terminal
        esc = string(27b)
        graph_on = esc+'[0/b'+esc+'[6/b'+esc+'[?38h'
        graph_off = esc+'[?38l'+esc+'[5/b'
        device, set_string = graph_on, reset_string = graph_off, /tek4014, $
            gin_chars=6
    end

    'mac':begin     ; Macintosh
         window, 2, xsize = 550, ysize = 700,  $
         title = ('WIND/STEP')
      end      

  'xtek': begin                         ; MIT X11 Xterm
        esc = string(27b)
        graph_on = esc+'[?38h'
        graph_off = esc+string(3b)
        device, set_string = graph_on, reset_string = graph_off, /tek4014
;            gin_chars=6
    end

    'ln03': begin                         ; LN03 printer
        esc = string(27b)
        graph_on = esc+'[?38h'
        graph_off = esc+string(3b)
        device, set_string = graph_on, reset_string = graph_off, /tek4014
    end

    '4125': begin                       ; TEK 4125 emulator on VWS
        device, /tek4100, color=64, /tek4014
    end

    'pericom': begin                    ; Pericom terminal
        device, /tek4014, set_string=string(29b), reset_string=string(24b), $
                gin_chars = 6
    end

    'ps': begin                         ; PostScript hard copy output
        if (ps_col eq 1) then begin
            device, /color, bits_per_pixel=8, /helvetica, /iso
	    !p.color = 1
        endif else begin
            device, /helvetica, color=0, /iso
        endelse
        !p.font = 0                         ; Use hardware fonts
        if (pstex) then device, /encapsulate $
        else            device, encapsulate = 0
    end

    'lj': begin                             ; LJ250 inkjet printer
        device, depth=3, resol=180
        ljlct
    end

    'idi': begin			    ; Image display interface
        device, character_size=[10,16]
    end

    else: 	 	                       ; Other device
endcase

if (wdev and not keyword_set(nowindow)) then begin        ; Windowing device.
    if (need_new_window) then begin
	if (!d.name eq 'X') then begin
	    pix = strupcase(getenv('HS_PIXMAP'))
	    if ((pix ne '') and (pix ne 'NO'))  then backstore = 2 $
						else backstore = 1
	endif else backstore = 1
        window, windex, xsize = sx, ysize = sy,  $
          title = (['ULYSSES/LAN', 'ACE/EPAM'])(instrument), $
    		    retain=backstore
	need_new_window = 0
    endif else begin
        wset, windex
	erase
	wshow
    endelse
endif

if (hard and pldname ne 'ln03') then begin ; Hard copy check direction
    case orient of
        0: if (pldname ne 'ps' or not pstex) then $
		device, /landscape, xsize=px, ysize=py, yoffset = px+3$
	   else device, /portrait, xsize=px, ysize=py
        1: begin
	    device, /portrait
            if pldname eq 'ps' then device, xsize = px, ysize = py, $
              yoffset = 3
        end
    endcase
endif

if (hard or !d.name eq 'CGM' or $
	(!d.name eq 'TEK' and plotfile ne '')) then begin
    ffn = form_fname(plotfile, pldir)
    junk = findfile(ffn, count=numb)
    if (!version.os ne 'vms' and numb ne 0) then begin
	npfile=mk_plname(pldname)
	ffn = form_fname(npfile, pldir)
	hs_err_msg, ['File: '+plotfile+' already exists in plot directory', $
		     'Using: '+npfile+' instead']
	plotfile = npfile
    endif
    device, filename = ffn
endif else if (pldname eq 'tek') then begin
    dummy = ' '
    read, 'Switch terminal to tek mode and press return.',dummy
endif

;       Set up a simple colour table (based on the PGPLOT default)
;	(Firstly re-verify that there really is a colour table,
;	but note we don't do this if there doesn't seem to be a table)

if (coltab) then coltab = (!d.table_size gt 2)

if (coltab and not keyword_set(nowindow)) then begin
    if (bg eq 'W' or hard) then begin
        bbc = 255b
        bfg = 0b
    endif else begin
        bbc = 0b
        bfg = 255b
    endelse
    if (n_elements(red) eq 0) then begin
        red = [bbc, bfg, 255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
               0b, 127b, 255b, 85b, 170b]
        gre = [bbc, bfg, 0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
               127b, 0b, 0b, 85b, 170b]
        blu = [bbc, bfg, 0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
               255b, 255b, 127b, 85b, 170b]
    endif else begin
        red(0:1) = [bbc, bfg]
        gre(0:1) = [bbc, bfg]
        blu(0:1) = [bbc, bfg]
    endelse
    tvlct, red, gre, blu
    tvlct, bfg, bfg, bfg, !d.n_colors-1 ; Make max color same colour as 1 as well 
                                        ; (mainly for X)
endif else if (!d.flags and 8) ne 0 then device, /floyd

nchx = !d.x_size/!d.x_ch_size

if nchx lt 80 then size_factor = float(nchx)/80.0 $
else               size_factor = 1.0

if n_elements(plot_zone) ne 0 then size_factor = size_factor * $
                                                 min(plot_zone.size)

end
