;+
; PLOT_MENU
;       Selects plot device, via a widget interface.
;
; Call:
;       plot_menu
;
; Argument:
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;	modal		input	If set & non-zero, then register modally
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;       Prototype, from PLOPEN: 6/1/93; SJT
;	Add region setting: 11/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use compound widget CW_FSLIDER for region: 29/1/93; SJT
;	Fix initial colour table status of PS: 3/2/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Force unique filenames in unix: 17/2/93; SJT
;	Add modal keyword to optioanlly prevent return, during
;		forced call from movie: 4/3/93; SJT
;	Tidy up and minor fixes: 29/7/93; SJT
;	Add "standard" windows: 22/11/93; SJT
;	Separate page size and window size: 20/4/94; SJT
;	Force scrolling if the base is too big: 21/4/94; SJT
;	Move region setting out to separate menu & add char sizes:
;							29/6/94; SJT
;	Add LN03 "Pseudo-device": 28/7/94;SJT
;	Remove background setting from colour hardcopy devices:
;	25/7/95; SJT
;-

pro plot_event, event

;	The event handler

@plot_reg
@dcs
@plot_settings
@directories
@plot_wid
@wid_set

widget_control, event.id, get_uval=but

i_change_dev = 0

case but of
    'DONE': begin
	if (hard or (devname eq 'TEK') or (devname eq 'CGM')) then begin
	    widget_control, filnm, get_value=fn
	    plotfile = fn(0)
	endif else if (wdev) then begin
	    widget_control, witxt, get_value=fn
	    wnumber = fix(fn(0))
	    if (wnumber ne windex) then begin
		windex = wnumber
		need_new_window = 1
	    endif
	endif
	widget_control, event.top, /destroy
	goto, setup
    end

;	Size options

    'WIND-X': begin
	widget_control, event.id, get_value=sx
	need_new_window = 1
     end

    'WIND-Y': begin
	widget_control, event.id, get_value=sy
	need_new_window = 1
    end

    'HARD-X': begin
	widget_control, event.id, get_value=px
	px = float(px) /10.
    end

    'HARD-Y': begin
	widget_control, event.id, get_value=py
	py = float(py) /10.
    end

;	Switched options.
    
    'PORT': begin
        orient = event.select
        tmp = px
        px = py
        py = tmp
        widget_control, xsl_hard, set_value = fix(px * 10.)
        widget_control, ysl_hard, set_value = fix(py * 10.)
    end
            
    'PSCOL': begin
        ps_col = event.select
        coltab = event.select
    end
            
    'TEX': pstex = event.select
    
;	Filename

    'FILEN': begin
	widget_control, event.id, get_value=fn
	plotfile = fn(0)
    end

;	Window index (no action at this stage)

    'WINDEX': 

;	Background colour

    'BGC': bg = (['B', 'W'])(event.select)
    
;	Character size
    
    'SMALL': char_sizes = -1
    'AUTOMATIC': char_sizes = 0
    'LARGE': char_sizes = 1
    
;	Plot region, colour table
    
    'REGION': region_menu, group = event.top    
    'COLOUR': colour_menu, group = event.top
    
;	Terminal selections.
;	N.B. Some of these may not have menu items.

    'T5': begin                         ; Cifer T5 terminal
        pldname = 't5'
	devname = 'TEK'
        hard = 0
        coltab = 0
        wdev = 0
	plotfile = ''
	i_change_dev = 1
    end

    '4125': begin                       ; TEK 4125 emulator on VWS
        pldname='4125'
	devname = 'TEK'
        hard = 0
        coltab = 1
        wdev = 0
	plotfile = ''
	i_change_dev = 1
    end

    'PERICOM': begin                    ; Pericom terminal
        pldname = 'pericom'
	devname = 'TEK'
        hard = 0
        coltab = 0
        wdev = 0
	plotfile = ''
	i_change_dev = 1
    end

    'XTEK': begin			; MIT X11 Xterm tek mode
        pldname = 'xtek'
	devname = 'TEK'
        hard = 0
        coltab = 0
        wdev = 0
	plotfile = ''
	i_change_dev = 1
    end
    
    'LN03': begin
        pldname = 'ln03'
        devname = 'TEK'
        hard = 1
        coltab = 0
        wdev = 0
	i_change_dev = 1
    end
        
    'PS': begin                         ; PostScript hard copy output
        pldname = 'ps'
	devname = strupcase(pldname)
        hard = 1
        wdev = 0
	coltab = ps_col
	i_change_dev = 1
    end

    'LJ': begin                             ; LJ250 inkjet printer
        pldname = 'lj'
	devname = strupcase(pldname)
        coltab = 0
        wdev = 0
	hard = 1
	i_change_dev = 1
    end

    'PCL': begin			  ; HP Printer control language
	pldname = 'pcl'
	devname = strupcase(pldname)
	hard = 1
	coltab = 0
	wdev = 0
	i_change_dev = 1
    end

    'CGM': begin			; Colour graphics metafile
	pldname = 'cgm'    
	devname = strupcase(pldname)
	hard = 1		; For these purposes
	coltab = 1
	wdev = 0
	i_change_dev = 1
    end


    else: begin                         ; Other device, or a default size
	if (strmid(but,3,1) eq 'x' and strlen(but) eq 7) then begin
	    sx = fix(strmid(but,0,3))
	    sy = fix(strmid(but,4,3))
	    widget_control, xsl, set_value=sx
	    widget_control, ysl, set_value=sy
	    need_new_window = 1
        endif else begin
	    pldname = strlowcase(but)
	    devname = strupcase(pldname)
            set_plot, pldname
            wdev = (!d.flags and 256) ne 0
            hard = (!d.flags and 512) ne 0
            coltab = (!d.table_size gt 2)
  	    set_plot, wid_dev
	    if (wdev) then need_new_window = 1
	    i_change_dev = 1
	endelse
    end
endcase

if (i_change_dev) then begin
    if (hard) then plotfile = mk_plname(pldname) $
    else           plotfile = ''
endif

;	Echo the device name and file

widget_control, filnm, set_value=plotfile

;	Set the sensitivities & mappings according to the device

widget_control, hardbase, map=hard
widget_control, filebase, sensitive = (hard or (devname eq 'TEK') or $
					(devname eq 'CGM'))

widget_control, winbase, map = ((not hard) and 1)
widget_control, winbase, sensitive=wdev

widget_control, colbut, sensitive = (pldname eq 'ps')
widget_control, texbut, sensitive = (pldname eq 'ps')
widget_control, bgbase, sensitive = (coltab and (not hard))
widget_control, mode_but, sensitive = (pldname ne 'ln03')
widget_control, xsl_hard, sensitive = (pldname ne 'ln03')
widget_control, ysl_hard, sensitive = (pldname ne 'ln03')

return

;	These things only need to be done on exiting

setup:

end

pro plot_menu, group=group, modal=modal

;	This is the routine that actually creates the menus etc.

@plot_wid
@plot_settings
@path_dirs
@wid_set
@plot_reg
@wid_fonts

if (xregistered('plot')) then return	; Don't make a second copy.

wid_dev = !d.name

devfile = form_fname('devlist.'+!version.os, data_dir)
openr, ilu, /get, devfile
nextdev = ''
repeat begin
    readf, ilu, nextdev
    if (strlen(nextdev) gt 0) then begin
	if (strmid(nextdev,0,1) ne '*') then begin
            if (n_elements(devlist) eq 0) then	devlist = nextdev $
            else				devlist = [devlist, nextdev]
        endif
    endif
endrep until eof(ilu)
free_lun, ilu

defsize = ['640x512', '512x640', '800x800', '800x512', '640x800', $
	   '512x512', '640x640', '800x640']

;		Set defaults for those plot settings which
;		will be needed for intial values

if n_elements(pldname) eq 0 then pldname = strlowcase(!d.name)
if n_elements(devname) eq 0 then devname = !d.name
if n_elements(wdev) eq 0 then wdev = 1
if n_elements(hard) eq 0 then hard = 0
if n_elements(orient) eq 0 then orient = 0
if n_elements(ps_col) eq 0 then ps_col = 0
if n_elements(pstex) eq 0 then pstex = 0
if n_elements(sx) eq 0 then begin
    sx = 640
    sy = 512
endif
if (n_elements(px) eq 0) then begin
    px = ([23.5, 17.8])(orient)
    py = ([17.8, 23.5])(orient)
endif
    
if (n_elements(windex) eq 0) then windex = 0
if n_elements(coltab) eq 0 then coltab = (!d.table_size gt 2)
if (n_elements(bg) eq 0) then begin
    if (not hard) then begin
        tvlct, /get, r, g, b, 0
        if (r(0) lt 127b) then bg = 'B' else bg = 'W'
    endif else bg = 'W'
endif
if (n_elements(plot_zone) eq 0) then $
	plot_zone = {plot_zone, corner:[0., 0.], size:[1., 1.]}
if (n_elements(char_sizes) eq 0) then char_sizes = 0


;	determine maximum screen size for sliders

device, get_screen_size = screen

;	Ascertain the widget tool kit in use as they need different
;	numbers of columns in the device menu: 10 for open look, 6 for
;	motif

if (strupcase(wid_version.style) eq 'OPEN LOOK') then	dcol = 8 $
else				 			dcol = 6

;	Top level base

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(/column, xpad = 5, ypad = 5, $
                                     title = 'Plot ' + $
                                     'Devices', /scroll, x_scroll_size $
                                     = xss, y_scroll_size = yss) $
else base = widget_base(/column, xpad = 5, ypad = 5, title $
                        = 'Plot Devices')

txt = widget_label(base, frame=2, value='Plot Device Settings', font=large_v)

;	Base for device selections

devbase = widget_base(base, /column, /frame)
devlab = widget_label(devbase, value='Device Selection', font=large_v)
xmenu, devlist, devbase, /exclusive, /no_release, uvalue=devlist, $
  column = dcol, buttons = bid, font = normal_v
loc = where(strupcase(devlist) eq strupcase(pldname))
if (loc(0) ne -1) then widget_control, bid(loc(0)), /set_button

;	Sizings (window and hard are alternately mappable)

jb = widget_base(base)

;	Window sizings

winbase = widget_base(jb, /column, /frame)
wb0 = widget_base(winbase, /row)

xwbase = widget_base(wb0, /column)
xl = widget_label(xwbase, value = 'X-dimension of window (pixels)', $
                  font = normal_v)
xsl = widget_slider(xwbase, minimum = 20, maximum=screen(0), value=sx, $
	uvalue='WIND-X', font=normal_v)

ywbase = widget_base(wb0, /column)
yl = widget_label(ywbase, value = 'Y-dimension of window (pixels)', $
                  font = normal_v)
ysl = widget_slider(ywbase, minimum = 20, maximum=screen(1), value=sy, $
	uvalue='WIND-Y', font=normal_v)

wwb = widget_base(winbase, /row)

jbw = widget_base(wwb, /column)
junk = widget_label(jbw, value='Window index:', font=normal_v)
witxt = widget_text(jbw, /edit, /frame, xsize=12, ysize=1, $
	value=string(windex), uvalue='WINDEX', font=normal_f)

stdbase = widget_base (wwb, /column)
junk = widget_label(stdbase, value = 'Standard windows', font = normal_v)
xmenu, defsize, stdbase, uvalue = defsize, row = 2, $
  font = normal_v

;	Hardcopy sizings, etc

hardbase = widget_base(jb, /column, /frame)
hardbase1 = widget_base(hardbase, /row)
xhbase = widget_base(hardbase1, /column)
xl = widget_label(xhbase, value='X-dimension of page (mm)', font=normal_v)
px0 = fix(px*10)
xsl_hard = widget_slider(xhbase, minimum = 25, maximum=320, value=px0, $
	uvalue='HARD-X', font=normal_v)

yhbase = widget_base(hardbase1, /column)
yl = widget_label(yhbase, value='Y-dimension of page (mm)', font=normal_v)
py0 = fix(py*10)
ysl_hard = widget_slider(yhbase, minimum = 25, maximum=320, value=py0, $
	uvalue='HARD-Y', font=normal_f)

hardopts = [['Landscape Mode', 'Portrait Mode'], $
            ['B & W', 'Colour'], $
            ['Normal', 'EPS (TeX mode)']]
xmenuplus, /toggle, hardopts, hardbase,  $
  uvalue = ['PORT', 'PSCOL', 'TEX'], /row,  $
  state = [orient, ps_col, pstex], buttons =jbids, $
  font = normal_v, base = hardbase2
                      
mode_but = jbids(0)
colbut = jbids(1)
texbut = jbids(2)

if (pldname ne 'ps') then begin
    widget_control, colbut, sensitive=0
    widget_control, texbut, sensitive=0
endif
if (pldname eq 'ln03') then begin
    widget_control, mode_but, sensitive = 0
    widget_control, xsl_hard, sensitive = 0
    widget_control, ysl_hard, sensitive = 0
endif

if (hard) then begin
    widget_control, hardbase, /map
    widget_control, winbase, map=0
    if (not wdev) then widget_control, winbase, sensitive=0
endif else begin
    widget_control, hardbase, map=0
    widget_control, winbase, /map
endelse

;		output file selection

mb = widget_base(base, /row)

filebase = widget_base(mb, /row, /frame)
fillb = widget_label(filebase, value='Plot output file: ', font=normal_v)
if (hard) then plotfile = mk_plname(pldname) $
else plotfile = ''
filnm = widget_text(filebase, /edit, /frame, value=plotfile, uvalue='FILEN', $
	xsize=20, ysize=1, font=normal_f)
if (not hard) and devname ne 'TEK' and devname ne 'CGM' then $
	widget_control, filebase, sensitive=0

;	background

bgbase = widget_base(mb, /row, /frame)
bglab = widget_label(bgbase, value='Background Colour', font=normal_v)
bgc = ['Black', 'White']
state = (bg eq 'W')
bid = cw_tbutton(bgbase, value = bgc, font = normal_v, uvalue = $
                 'BGC', state = state)

if (hard or (not coltab)) then widget_control, bgbase, sensitive = 0

;	Character sizes

csbase = widget_base(base, /row, /frame)
cslab = widget_label(csbase, value = 'Character Sizing', font = normal_v)
chszz = ['Small', 'Automatic', 'Large']
xmenu, chszz, csbase, /row, /exclusive, /no_release, uvalue = $
  strupcase(chszz), button = bid, font = normal_v

widget_control, bid(char_sizes+1), /set_button

;	Region & colour menus

jb = widget_base(base, /row)
rb = widget_button(jb, value = 'Plotting region', uvalue = 'REGION', $
                   font = normal_v)
rb = widget_button(jb, value = 'Colours', uvalue = 'COLOUR', font = $
                   normal_v)

;	Exit button

db = widget_button(base, value='Done', uvalue='DONE', font=normal_v)

;	Realize and register

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif


if (not keyword_set(modal)) then xmanager, 'plot', base, group=group $
else				 xmanager, 'plot', base, /modal

end
