;+
; PLCL_MENU
;	Menu interface for CLOSE_PLOT
;
; Usage:
;	plcl_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 6/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Force scrolling if the base is too big: 21/4/94; SJT
;	Do own management, to avoid a nasty with XMANAGER: 13/12/94; SJT
;-

function plcl_event, event

@plot_settings
@plcl_wid
@spool_action
@directories

widget_control, event.id, get_uval=but

case but of
    'BG': iback = event.select

    'INS': widget_control, acttxt, /append, set_value=plotfile

    'RES': widget_control, acttxt, set_value=expand_command(spool_cmd)

    'CLR': widget_control, acttxt, set_value=''

    'NO': begin
;;	widget_control, event.top, /destroy
        return, {id:event.id, top:event.top, handler:event.handler, exited:1}
    end

    'DO': begin
	widget_control, acttxt, get_value=com
;;	widget_control, event.top, /destroy
	com = com(0)
	spool_cmd = expand_command(com, /compress)
	cd, pldir, current=cdir
        if com ne '' then begin
            if (iback) then begin
                if !Version.os eq 'vms' then $
                  spawn, com, /nowait, /notify $
                else  spawn, com+' &'
            endif else begin
                spawn, com, comout
                hs_err_msg, comout
            endelse
        endif
	cd, cdir
	return, {id:event.id, top:event.top, handler:event.handler, exited:1}
    end

;	Ignore anything else (i.e. the text widget)

    else:

endcase

return, {id:event.id, top:event.top, handler:event.handler, exited:0}

end

pro plcl_menu, group=group

@plot_settings
@plcl_wid
@spool_action
@wid_fonts
@wid_set

mbuttons = ['Insert filename', 'Restore', 'Clear', 'No-action', 'Do it']
muv = ['INS', 'RES', 'CLR', 'NO', 'DO']
iback = 0
os = strupcase(!version.os)
cmd = expand_command(spool_cmd)

base = widget_base(/column, title = 'Plot Disposal', xpad = 5, ypad = 5)

txt = widget_label(base, value='Plot File Disposal', frame=2, font=large_v)

actbase = widget_base(base, /row)
junk = widget_label(actbase, value=os+' command: ', font=normal_v)
acttxt = widget_text(actbase, /edit, /frame, uvalue='OS', value=cmd, $
	xsize=40, ysize=1, font=normal_f)

jb = widget_base(base, /row)
junk = widget_label(jb, value = 'Run spool command in:', font = $
                    normal_v)
junk = cw_tbutton(jb, value = ['Foreground', 'Background'], uvalue = $
                  'BG', font = normal_v, state = iback+0)

xmenu, mbuttons, base, /row, uvalue = muv, font = normal_v

widget_control, base, /real
widget_control, acttxt, /input_focus

;	We do our own widget management here, because otherwise if
;	this routine creates the message window it gets stuck in a
;	modal loop and makes a horrid mess.

widget_control, base, event_func = 'plcl_event'

repeat begin
    ev = widget_event(base)
endrep until (ev.exited eq 1)

widget_control, base, /destroy

end
