function mk_plname, device

;+
; MK_PLNAME
;	Make a suitable filename for a plot to a given device.
;
; Usage:
;	name = mk_plname(device)
;
; Return Value:
;	name	string	A suitable filename.
;
; Argument:
;	device	string	input	The IDL device name.
;
; Method:
;	VMS: Just returns lan.<device>, relies on the version number
;	system to separate files.
;
;	Unix: No version numbers, so use lan.<device>.<n> where n is
;	the lowest unused number (starting from 1).
;
; History:
;	Original: 17/2/93; SJT
;-

@directories

if (n_elements(pldir) eq 0 and !version.os ne 'vms') then begin
    hs_err_msg, ['Plot directory is not yet defined', $
		 'Cannot ensure distinct file name']
    return, 'lan.'+device
endif

if (!version.os eq 'vms') then return, 'lan.'+device

n = 0
name = 'lan.'+device+'.*'
fn = findfile(form_fname(name,pldir),count=ifind)

repeat begin
    n = n+1
    name = 'lan.'+device+'.'+strtrim(string(n),2)
endrep until ((where(fn eq form_fname(name,pldir)))(0) eq -1)

return, name

end
