;+
; MK_FN_MENU
;	Widget interface for manual file selection.
;
; Usage:
;	fn = mk_fn_menu(day, year, archive, extn)
;
; Arguments: (all input only)
;	day	int	The day of year from which search is made
;	year	int	The year for which search is made
;	archive	string	The default archive name
;	extn	string	The default extension.
;
; Keywords: none
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original (from G_ALL_MENU): 1/2/93; SJT
;	Fix format to be In.n: 7/6/93; SJT
;	Force scrolling if the base is to big: 21/4/94; SJT
;-

pro mk_fn_event, event

;	The event handler

@directories
@mk_fn_wid

widget_control, event.id, get_uvalue=but

case but of

;	Exits

    'CANCEL': begin
        widget_control, event.top, /destroy
        widget_control, /hourglass
	sfname = ''
	return
    end

    'DO': begin
        widget_control, event.top, /destroy
        widget_control, /hourglass
	return
    end

;	Directories

    'DAT': begin
	widget_control, dirtxt, set_value=dir
	sfdir = dir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'CUR': begin
	widget_control, dirtxt, set_value=currdir
	sfdir = currdir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'PLO': begin
	widget_control, dirtxt, set_value=pldir
	sfdir = pldir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'CLE': begin
	widget_control, dirtxt, set_value=''
	sfdir = ''
	widget_control, selmenu, set_value=['']
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'DIR': begin
	widget_control, dirtxt, get_value=txt
	sfdir = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'FILT': begin
	widget_control, filttxt, get_value = txt
	sffilt = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
    end

    'SELECT': begin
	sfname = flist(event.index)
	widget_control, selfile, set_value=sfname
	ido = 1
    end

endcase

widget_control, dobut, sensitive=ido
end

function mk_fn_menu, p1, p2, p3, p4

;	Menu maker

@directories
@mk_fn_wid
@wid_fonts
@wid_set
@file_info

;	Output file things

dirch = ['Data', 'Plot', 'Current', 'Clear', 'Apply']
udirc = ['DAT', 'PLO', 'CUR', 'CLE', 'DIR']

cd, current= currdir
sfdir = dir
ido = 0

case n_params() of
    4: begin                    ; p1=year, p2=day, p3=archive, p4=extn
        sffilt = string(p3, p2, p1, p4, $
                        format = "('*',a,'*',i2.2,i3.3,'*',a,'*')")
    end
    2: begin                    ; p1=archive, p2=extn
        sffilt = string(p1, p2, format = "('*',a,'*',a)")
    end
    0: begin                    ; use the "file_info" settings
        if (n_elements(arc_prefix) eq 0) then set_archive, /ula
        sffilt = string(arc_prefix, arc_suffix, format = "('*',a,'*',a)")
    end
    Else: begin
        hs_err_msg, ['*** ERROR *** Invalid number of arguments', $
                     ' Must be 0, 2 or 4']
        return, ''
    end
endcase

;	Base widgets

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'File Name', xpad = 5, $
                                     ypad = 5, /column, $
                                     /scroll, x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(title = 'File Name', xpad = 5, ypad = 5, $
                        /column)

txt = widget_label(base, value = 'Manual filename selection', $
	frame=2, font=large_v)

;	The file name

inbase = widget_base(base, /column, /frame)
junk = widget_label(inbase, value='Input file selection', font=normal_v)

jb = widget_base(inbase, /column, /frame)
dirbase = widget_base(/row, jb)
dirlab = widget_label(dirbase, val='Directory', font=normal_v)
dirtxt = widget_text (/edit, dirbase, value=sfdir, uval='DIR', $
	xsize=40, ysize=1, /frame, font=normal_f)
xmenu, dirch, jb, uvalue = udirc, buttons = bid, /row, font = normal_v

filtbase = widget_base(/row, /frame, inbase)
filtlab = widget_label(filtbase, val='Filter', font=normal_v)
filttxt = widget_text(/edit, filtbase, value=sffilt, uval='FILT', $
	xsize=40, ysize=1, /frame, font=normal_f)
junk = widget_button(filtbase, value='Apply', uval='FILT', font=normal_v)

selbase = widget_base(/column, /frame, inbase)
sellab = widget_label(selbase, val='File Selection Menu', font=normal_v)
sp = form_fname(sffilt, sfdir)
flist = findfile(sp)
selmenu = widget_list(selbase, val=flist, uval='SELECT', $
	ysize=6, /frame, font=normal_f)

sfname =''
sellab2 = widget_label(selbase, val='Selected File', font=normal_v)
selfile = widget_text(selbase, /frame, val=sfname, xsize=50, ysize=1, $
	font=normal_f)

;	Exit buttons

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)
widget_control, dobut, sensitive = 0

;	realize

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

xmanager, 'mk_fn', base, /modal		; MUST be /modal to prevent
					; premature return

return, sfname

end
