;+
; MISMATCH_MENU
;
; Usage:
;	mismatch_menu
;
; Arguments: none
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 8/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;-

pro mismatch_event, event

;	The event handler

@versions

widget_control, event.id, get_uvalue=but

case but of
   'CANCEL': begin
	widget_control, event.top, /destroy
	return
   end

   'P': mm_action = 0
   'I': mm_action = 1
   'C': mm_action = 2
   'T': mm_action = 3
   'A': mm_action = 4
endcase

widget_control, event.top, /destroy
return

end

pro mismatch_menu, group=group

;	Menu maker

@versions
@wid_fonts
@wid_set

if (xregistered('mismatch')) then return	; Don't make a second copy.

if (n_elements(mm_action) eq 0) then mm_action = 0

acts = ['Prompt', 'Ignore', 'Continue', 'Truncate', 'Abort']
uacts = ['P', 'I', 'C', 'T', 'A']
ubox = intarr(5)
ubox(mm_action) = 1

base = widget_base(title = 'Mismatch Action', /column, xpad = 5, ypad = 5)

txt = widget_label(base, value='Version mismatch action', $
	frame = 2, font=large_v)

xmenuplus, acts, base, column = 3, uvalue = uacts, boxes = ubox, font $
  = normal_v

dobut = widget_button(base, value='Cancel', uvalue='CANCEL', font=normal_v)

widget_control, base, /real
xmanager, 'mismatch', base, group=group

end
