pro mismatch, prompt=prompt, ignore=ignore, continue=continue, $
	truncate=truncate, abort=abort

;+
;  MISMATCH
;	Set the action to be taken on finding a file version mismatch while
;	reading data.
;
;  Usage:
;	mismatch[, /prompt, /ignore, /continue, /truncate, /abort]
;
;  Keywords:
;	prompt	undef	input	Prompt for choice of action on any mismatch.
;	ignore	undef	input	Ignore mismatches entirely.
;	continue undef	input	Print a message summarising the mismatch and continue.
;	truncate undef	input	Truncate the plot at the first mismatch.
;	abort	undef	input	Abandon the plot entirely on any mismatch.
;
;  Restrictions:
;	Only one key may be given.
;
;  History:
;	Original: 16/12/92; SJT
;-

@versions

if (((nkey = keyword_set(prompt)+keyword_set(ignore)+keyword_set(continue)+ $
	keyword_set(truncate)+keyword_set(abort))) gt 1) then begin
    print, '**** ERROR **** May only specify one keyword'
    return
endif

if      (keyword_set(prompt))   then mm_action = 0 $
else if (keyword_set(ignore))   then mm_action = 1 $
else if (keyword_set(continue)) then mm_action = 2 $
else if (keyword_set(truncate)) then mm_action = 3 $
else if (keyword_set(abort))    then mm_action = 4 $
else begin
    if (n_elements(mm_action) eq 0) then mm_action = 0
    dact = (['P','I','C','T','A'])(mm_action)
    iact = ''
action:
    read, 'Action to take on file version mismatch (? for list) <'+dact+'> :_',$
			iact
    case strupcase(iact) of
	'P': mm_action = 0
	'I': mm_action = 1
	'C': mm_action = 2
	'T': mm_action = 3
	'A': mm_action = 4
	'':
	'?': begin
	    openw, ilu, /get, filepath(/terminal), /stream, /more
	    printf, ilu, 'Acceptable options are:'
	    printf, ilu, 'P  -  Prompt user for action on a mismatch'
	    printf, ilu, 'I  -  Ignore mismatches entirely'
	    printf, ilu, 'C  -  Continue, but print a warning message'
	    printf, ilu, 'T  -  Truncate plot at first mismatch'
	    printf, ilu, 'A  -  Abort entire plot on any mismatch'
	    free_lun, ilu
	    goto, action
	end
	else: goto, action
    endcase
endelse

end
