function Match_names, wanted

;+
; MATCH_NAMES
;	Matches a specified name to list of avaliable names, with due
;	priorities for compressed, incomplete and QEDR files.
;
; Usage:
;	real_name = match_names(wanted)
;
; Return value:
;	real_name	string	The actual filename found (including
;				directory)
;
; Arguments:
;	wanted	string	input	The standard filename wanted.
;
; Method:
;	The search is made in the order:
;		Normal files,
;		Incomplete files,
;		QEDR derived files,
;		Incomplete QEDR derived files.
;	.Z and .gz files are recognized and decompression is ordered.
;
; History:
;	Original: 21/10/94; SJT
;	Fix case problem in VMS: 2/11/94; SJT
;	Fix possible problem when dir is in name list: 11/7/95; SJT
;	Decompression now removed since HSIO now supports dynamic
;	decompression: 4/12/97; SJT
;-

@make_fname_cmn
@directories

if (!Version.os eq 'vms') then $
  matches = where(strpos(strupcase(files), strupcase(wanted)) ne -1, $
                  n_match) $
else $
  matches = where(strpos(files, wanted) ne -1, n_match)

if (n_match eq 0) then return, ''
if (n_match gt 1) then  hs_err_msg, ['** WARNING** Multiple file matches:', $
                                     files(matches), 'Using first one']
fn = files(matches(0))

if (strpos(fn, dir) eq -1) then fn = form_fname(fn, dir)

return, fn

end

