pro Markpos, dates, rates, ipanels, one_value=one_value

;+
; MARKPOS
;	Mark one or more positions on a single plot.
;
; Usage:
;	markpos[, date, rate, ipanel, /one_value]
;
; Arguments:
;	date	float	output	The dates marked.
;	rate	float	output	The rates marked.
;	ipanel	int	output	The panels marked.
;
; Keyword:
;	one_value ?	input	If set, then just read a single value
;				and exit.
; Restrictions:
;	A single plot against time must be present, and the device
;	must support cursor reading.
;
; History:
;	Original: 24/5/94; SJT
;	Extend to multi-panel and non-time plots: 1/6/94; SJT
;	Return all marked positions: 25/4/95; SJT
;	Add check & warning for PHA matrix plots: 23/11/95; SJT
;-

@time_limits
@trans_stack
@settings

if ((!D.flags and 256) eq 0) then begin
    hs_err_msg, "MARKPOS only works on windowing devices."
    return
endif

if (ispha) then hs_err_msg, ["Current plot is a PHA matrix plot", $
                             "PHA_MARKPOS will yield more " + $
                             "information."]

msg = ["To mark a point, click on the left mouse button", $
       "To exit, click on the right button."]
if (keyword_set(one_value)) then msg = msg(0)
hs_err_msg, msg

istart = 1
device, get_graphics_function = old_funct, set_graphics_function = 6

first_one = 1b

repeat begin
    cursor, /norm, x, y, 2
    case !Err of
        1: begin                ; Enter a value
            cursor_within, x, y
            pos = convert_coord(/norm,  /to_data, x, y)
            rate = pos(1)
            xd = pos(0)
            ipanel = ctfm+1
            if (istime(ctfm)) then begin
                h = long(xd)
                xm = (xd-h)*60.
                m = fix(xm)
                s = (xm-m)*60.
                date = norm_time([tstart(0:1), h, m, s])
                if (use_date) then begin
                    datecon, date(0), date(1), mth, dte
                    msg = string(rate, date(0), mth, dte, date(2:*), $
                                 ipanel, form = "('Y value = ',G9.4,' " + $
                                 "Date = ',I4,' ',A3,I3,' ', 2(I2.2, " + $
                                 "':'), f5.2, ' Panel index = ', I2)")
                endif else msg = string(rate, date, ipanel, form = $
                             "('Y value = ',G9.4,' Date = ',I4,'/',I3," + $
                             "' ', 2(I2.2, ':'), f5.2, ' Panel index = ',I2)")
            endif else begin
                msg = string(rate, xd, ipanel, form = $
                             "('Y value = ',G9.4, ' X value = '," + $
                             "G9.4,' Panel index = ', I2)")
                date = xd
            endelse
            if (first_one) then begin
                dates = date
                rates = rate
                ipanels = ipanel
                first_one = 0b
            endif else begin
                if (istime(ctfm)) then dates = [[dates], [date]] $
                else                   dates = [dates, date]
                rates = [rates, rate]
                ipanels = [ipanels, ipanel]
            endelse
            hs_err_msg, msg
            if (keyword_set(one_value)) then begin
                if (!X.type) then plots, 10.^!X.crange, [oy, oy], /data $
                else plots, !X.crange, [oy, oy], /data
                if (!Y.type) then plots, [ox, ox], 10.^!Y.crange, /data $
                else plots, [ox, ox], !Y.crange, /data
                device, set_graphics_function = 3
                return
            endif
        end            
        4: begin
            if (not istart) then begin
                if (!X.type) then plots, 10.^!X.crange, [oy, oy], /data $
                else plots, !X.crange, [oy, oy], /data
                if (!Y.type) then plots, [ox, ox], 10.^!Y.crange, /data $
                else plots, [ox, ox], !Y.crange, /data
            endif
            device, set_graphics_function = 3
            return
        end
        
        Else: begin             ; movement
            if (not istart) then begin
                if (!X.type) then plots, 10.^!X.crange, [oy, oy], /data $
                else plots, !X.crange, [oy, oy], /data
                if (!y.type) then plots, [ox, ox], 10^!Y.crange, /data $
                else plots, [ox, ox], !Y.crange, /data
            endif
            cursor_within, x, y
            pos = convert_coord(/norm, /to_data, x, y)
            xd = pos(0)
            yd = pos(1)
            if (!X.type) then plots, 10.^!X.crange, [yd, yd], /data $
            else plots, !X.crange, [yd, yd], /data
            if (!Y.type) then plots, [xd, xd], 10.^!Y.crange, /data $
            else plots, [xd, xd], !Y.crange, /data
            istart = 0
            ox = xd
            oy = yd
        end
    endcase
;;    cursor, x, y, /up
endrep until !Err eq 4

device, set_graphics_function = 3

end
