pro logticks, range, ticks, tickv

;+
;  LOGTICKS
;	Return a set of ticks to produce decade logarithmic plots at all times.
;
;  Usage:
;	logticks, range, ticks, tickv
;
;  Arguments:
;	range	float	input	the range of the plot.
;	ticks	int	output	The number of ticks.
;	tickv	float	output	The tick values.
;
;  Restrictions:
;	The outputs must be used in a call like:
;	plot_oo, ..., xtickv=tickv, xticks=ticks, xminor=9,...
;
;  History:
;	Original: 13/4/92; SJT
;-

tick_max = fix(alog10(range(1)))
if (range(1) lt 1.0) then tick_max = tick_max -1

if ((tick_min = alog10(range(0)))) gt fix(tick_min) then tick_min = tick_min+1
tick_min = fix(tick_min) < tick_max

tickv = 10.^(findgen(((ticks = tick_max - tick_min)) + 1)+tick_min)

end
