pro hs_info
;+
; HS_INFO
;	Display key settings.
;
; Usage:
;	hs_info
;
; Keyword:
;	group	long	Group-leader ID
;
; Restrictions:
;	Only displays major settings.
;
; History:
;	Original: 2/5/95; SJT
;-

@wid_set
@settings
@plot_settings
@versions
@directories
@file_info

if (n_elements(dir) eq 0) then ldir = 'Unset' else ldir = dir
if (n_elements(pldir) eq 0) then lpldir = 'Unset' else lpldir = pldir
if (n_elements(arc_prefix) eq 0) then begin
    flname = 'Unset'
    lres = 'Unset'
    ldur = 0
    lc = 'Undefined'
endif else begin
    flname = string(arc_prefix, arc_suffix, $
                    format = "(a,'yyddd',a)")
    if (arc_resolution ge 24.) then $
      lres = string(arc_resolution/24., format = "(f6.2,'d')") $
    else if (arc_resolution ge 1.) then $
      lres = string(arc_resolution, format = "(f5.2,'h')") $
    else if (arc_resolution ge 1./60.) then $
      lres = string(arc_resolution*60., format = "(f5.2,'m')") $
    else $
      lres = string(arc_resolution*3600., format = "(f5.2,'s')")
    
    ldur = arc_duration
    lc = (['Sparse', 'Filled'])(arc_comp)
endelse

if (n_elements(pldname) eq 0) then lpl = 'Unset' else lpl = pldname
if (n_elements(aver) eq 0) then aver = 0.
if (aver ge 1440.) then  $
  lav = string(aver/1440., format = "(f6.2,'d')") $
else if (aver ge 60.0) then  $
  lav = string(aver/60., format = "(f5.2,'h')") $
else if (aver ge 1.0) then $
  lav = string(aver, format = "(f5.2,'m')") $
else $
  lav = string(aver*60., format = "(f5.2,'s')")

if (n_elements(use_date) eq 0) then use_date = 0
if (n_elements(use_frame) eq 0) then use_frame = 1

message = string(!Hiscale, idf_vers, $
                 ldir, lpldir,  $
                 flname, lres, ldur, lc, $ 
                 lpl, $
                 lav, (['Doy', 'm/d'])(use_date), $
                 (['Off', 'On'])(use_frame), $
                 format = "(' '/'Hiscale software V',a," + $
                 "' Using IDF version ',f5.2/' '/" + $
                 "'Data directory: ',a / 'Plot spool directory: ',a/' '/" + $
                 "'Rate file names: ',a /" + $
                 "'Data cadence ',a,'; file duration ',I3,'d, '," + $
                 "a,' data packing'/' '/" + $
                 "'Plot device: ',a/" + $
                 "'Plot averaging: ',a/" + $
                 "'Date format: ',a,';  Plot frames & titles: ',a)")

hs_err_msg, message

end
