;+
; HS_HELP_MENU
;	Make and process a widget interface for HS_HELP.
;
; Usage:
;	HS_HELP_MENU
;
; Arguments: None
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original: 5/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Change button type of changes option: 27/10/94; SJT
;-

pro help_event, event

; Event handler for HS_HELP

@help_wid

widget_control, get_uval=i, event.id

case i of
    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
        widget_control, rtnsel, get_value = rou
        routine = rou(0)
	widget_control, event.top, /destroy
        hs_help, routine
	return
    end

    'CLEAR': widget_control, rtnsel, set_value=''
    'CHANGES': begin
	widget_control, event.top, /destroy
	hs_help, /changes
	return
    end


    'RTN': 				; Ignore the text widget event.

endcase

end

pro hs_help_menu, group=group
                                                                    
; Routine creates the help prompting hierarchy

@help_wid
@wid_fonts
@wid_set

if (float(!Version.release) ge 3.1) then man_proc, 'hiscale' $
else begin
    
    if (xregistered('help')) then return ; Don't make a second copy.
    
    if (n_elements(routine) eq 0) then routine = '00SUMMARY_DIR'

    base = widget_base(/column, /frame, xpad = 5, ypad = 5)

    txt = widget_label(base, value = 'Hiscale Help Utility', frame = 5, $
                       font = large_v)

    rtnbase = widget_base(base, /row, /frame)
    rtnlab = widget_label(rtnbase, value = 'Routine:', font = normal_v)
    rtnsel = widget_text(rtnbase, /frame, /edit, value = routine, $
                         uvalue = 'RTN', font = normal_f)

    jb = widget_base(base, /row)
    canbut = widget_button(jb, value = 'Cancel', uvalue = 'CANCEL', $
                           font = normal_v)
    clrbut = widget_button(jb, value = 'Clear', uvalue = 'CLEAR', font $
                           = normal_v)
    chbut = widget_button(jb, /frame, value = 'Changes', $
                          uvalue = 'CHANGES', font = normal_v)
    dobut = widget_button(jb, value = 'Do it', uvalue = 'DO', font = normal_v)

    widget_control, /real, base
    widget_control, rtnsel, /input_focus
    xmanager, 'help', base, group = group
endelse

end
