pro hs_help, routine, changes=changes

;+
; HS_HELP
;       Provides on line documentation on the use of the HI-SCALE software, and
;       the IDL user libraries.
;
; Usage:
;       hs_help[, routine, /changes]
;
; Argument:
;       routine string  input   The name of the routine for which help is
;                               needed, a list of the available routines
;                               follows.
;
; Keyword:
;       changes ?       input   If set and non-zero, then print the
;                               changes file.
;
; Method:
;       Uses the IDL DOC_LIBRARY or XDL procedure, unless the changes
;	key is given. 
;
; Restriction:
;       Routine argument, and changes key are exclusive.
;
; History:
;	Original: Lost in the mists of time; SJT
;	Removed routine list from here: 10/8/93; SJT
;	Use MAN_PROC if Version >= 3.1: 8/8/94; SJT
;-

@path_dirs
@wid_set
@wid_fonts

if (keyword_set(changes) and (n_params() eq 1)) then begin
    errmsg = [ $
	'**** ERROR **** /changes and <routine name> are exclusive', $
	'     Usage is any of:', $
	'      HS_HELP', $
	'      HS_HELP, /changes', $
	'      HS_HELP, <routine name>']
    hs_err_msg, errmsg
    return
endif

if (float(!Version.release)) then begin
    if (keyword_set(changes)) then request = "Hiscale recent_changes" $
    else if (n_params() eq 1) then request = "Hiscale "+routine $
    else request = "Hiscale"
    
    man_proc, request
    
endif else begin
    if n_params() eq 0 then routine = '00summary_dir'

    if (keyword_set(changes)) then begin
        if (!Version.os eq 'vms') then $
          change_name = 'HS_ROOT:[DOCS]CHANGES.TXT' $
        else $
          change_name = root_dir + '/docs/changes.txt'

        if (wid_mode) then hs_displayfile, change_name, font = normal_f $
        else begin
            openr, iluc, /get, change_name
            openw, ilut, /get, filepath(/terminal), /more, /stream

            l = ''
            while (not eof(iluc)) do begin
                readf, iluc, l
                printf, ilut, l
            endwhile

            free_lun, iluc, ilut
        endelse

    endif else if (wid_mode) then begin
        xdl, routine

    endif else begin
        doc_library, routine

    endelse
endelse

end

