pro hs_errplot, x, low, high, horizontal = horizontal

;+
; HS_ERRPLOT
;	Overplot error bars over a previously drawn plot.
;
; CATEGORY:
;	J6 - plotting, graphics, one dimensional.
; CALLING SEQUENCE:
;	HS_ERRPLOT, Low, High	;X axis = point number
;	HS_ERRPLOT, X, Low, High	;to specify abscissae
; INPUTS:
;	Low = vector of lower estimates, = to data - error.
;	High = upper estimate, = to data + error.
; OPTIONAL INPUT PARAMETERS:
;	X = vector containing abscissae.
; KEYWORD Parameters:
;	HORIZONTAL if set and non-zero, then plot the error bars || to the
;	x-axis
; OUTPUTS:
;	None.
; COMMON BLOCKS:
;	None.
; SIDE EFFECTS:
;	Overplot is produced.
; RESTRICTIONS:
;	Logarithmic restriction removed.
; PROCEDURE:
;	Error bars are drawn for each element.
;	For example:  Y = data values, ERR = symmetrical error estimates:
;		PLOT,Y	;Plot data
;		HS_ERRPLOT, Y-ERR, Y+ERR	;Overplot error bars.
;	If error estimates are non-symetrical:
;		PLOT,Y
;		HS_ERRPLOT, Upper, Lower	;Where upper & lower are bounds.
;	To plot versus a vector of abscissae:
;		PLOT,X,Y		;Plot data.
;		HS_ERRPLOT,X,Y-ERR,Y+ERR	;Overplot error estimates.
; MODIFICATION HISTORY:
;	DMS, RSI, June, 1983.
;	Joe Zawodney, LASP, Univ of Colo., March, 1986. Removed logarithmic
;		restriction.
;	DMS, March, 1989.  Modified for Unix IDL.
;	SJT (U. of Bham). Remove width, add HORIZONTAL. (Mar 1992)
;-

if n_params(0) eq 3 then begin	;X specified?
    up = high
    down = low
    xx = x
endif else begin	;Only 2 params
    up = x
    down = low
    xx=findgen(n_elements(up)) ;make our own x
endelse


n = n_elements(up) < n_elements(down) < n_elements(xx) 	;# of pnts
xxmin = min(!x.crange)			;X range
xxmax = max(!x.crange)
yymax = max(!y.crange)  		;Y range
yymin = min(!y.crange)

if (!x.type eq 1) then  begin		;Logarithmic X
    xxmax = 10.^xxmax
    xxmin = 10.^xxmin
endif 

if (!y.type eq 1) then begin		; Logarithmic Y
    yymax = 10.^yymax
    yymin = 10.^yymin
endif

if (keyword_set(horizontal)) then begin
    down = xxmin > down < xxmax
    up = xxmin > up < xxmax
    for i=0,n-1 do begin	;do each point.
        yyy = xx(i)		;y value
        if (yyy ge yymin) and (yyy le yymax) then $
		plots, [down(i),up(i)], [yyy,yyy]
    endfor
endif else begin
    down = yymin > down < yymax
    up = yymin > up < yymax
    for i=0,n-1 do begin	;do each point.
        xxx = xx(i)		;x value
        if (xxx ge xxmin) and (xxx le xxmax) then $
		plots,[xxx,xxx], [down(i),up(i)]
    endfor
endelse

return
end
