pro hs_err_event, event

;	The only possible event is a push to back

@directories
@hs_err_wid

widget_control, event.id, get_uvalue = ub

case (ub) of
    'DISMISS': widget_control, event.top, /destroy
    'CLEAR': widget_control, textid, set_value = ''
    'BACK': widget_control, event.top, show = 0
    
    'SAVE': begin
        widget_control, txbase, map = 0
        widget_control, savebase, map = 1
        widget_control, event.id, set_uvalue = 'DOSAVE'
    end
    
    'DOSAVE': begin
        widget_control, textid, get_value = text
        widget_control, sselfile, get_value = file
        
        on_ioerror, badfile
        openw, ilu, /get, file(0)
        printf, ilu, text, format = "(A)"
        free_lun, ilu
        widget_control, txbase, map = 1
        widget_control, savebase, map = 0
        widget_control, event.id, set_uvalue = 'SAVE'
    end
       
;	Directories

    'DAT': widget_control, sselfile, set_value=dir
    'PLO': widget_control, sselfile, set_value=pldir
    'CUR': widget_control, sselfile, set_value=currdir
    'NOSAVE': widget_control, sselfile, set_value=''
    
    Else:
    
endcase
return

Badfile:
widget_control, txbase, map = 1
widget_control, savebase, map = 0
widget_control, event.id, set_uvalue = 'SAVE'
hs_err_msg, 'Could not save text'

end

pro hs_err_msg, message, nostar=nostar, noshow=noshow
			
;+
; HS_ERR_MSG
;	Display an error message, in a suitable manner.
;
; Usage:
;	hs_err_msg, message
;
; Argument:
;	message	string	input	The error message to be displayed.
;
; Keywords:
;	nostar	ignored now.
;	noshow	If set, then don't pop the window to the front.
;
; History:
;	Original: 25/1/93; SJT
;	Modified to use Own widget system: 2/2/93; SJT
;	Force back to widget device & and nostart keyword: 4/3/93; SJT
;	Move-to-back button added: 24/8/93; SJT
;	Add facility to save contents of window: 11/1/95; SJT
;-

@wid_set
@plot_settings
@wid_fonts
@directories
@hs_err_wid

if isa(wid_mode) then begin
    cpd = !d.name
    set_plot, wid_dev
    if (not xregistered('hs_err', noshow = noshow)) then begin
        blabs = ['Dismiss', 'Clear', 'Push to Back', 'Save']
        bvals = ['DISMISS', 'CLEAR', 'BACK', 'SAVE']
        
        dirch = ['Data', 'Plot', 'Current', 'Clear']
        udirc = ['DAT', 'PLO', 'CUR', 'NOSAVE']
        dirchse = [n_elements(dir) ne 0, n_elements(pldir) ne 0, 1, 1]
        cd, current= currdir
        if (n_elements(pldir) ne 0) then sfdir = pldir $
        else				 sfdir = currdir
        sffile = ''

        base = widget_base(title = 'Hiscale Messages', $
		/column, xpad=5, ypad=5)
	txt = widget_label(base, frame = 2, $
		value='Hiscale Display Environment Messages', font=large_v)
        
        altbase = widget_base(base)
        
        txbase = widget_base(altbase, /column)
        textid = widget_text(txbase, value = message, xsize = 83, $
                             ysize = 12, /scroll, font = small_f)
        
        savebase = widget_base(altbase, /column)
        sselfile = widget_text(savebase, /edit, /frame, val = sffile, xsize $
                               = 50, ysize = 1, uvalue = 'SAVEFILE', $
                               font = normal_f) 
        xmenu, dirch, savebase, uvalue = udirc, buttons = bid, /row, $
          font = normal_v
        
        for i = 0, n_elements(dirch)-1 do $
          widget_control, bid(i), sensitive = dirchse(i)
        widget_control, savebase, map = 0
        
        xmenu, blabs, base, uvalue = bvals, /row, $
          font = normal_v
        
	widget_control, base, /real

	xmanager, 'hs_err', base, group=topbase

    endif else widget_control, textid, /append, set_value=message
    set_plot, cpd
endif else print, message, format="(A)"

end

