;+
; HDF_BG
;	Get background action for Greyscale display of HDF file.
;
; Usage:
;	bwfix = hdf_bg(file, im_min)
;
; Return Value:
;	bwfix	int	0 if no background fixing, 1 if fix is to be
;			done.
;
; Argument:
;	file	string	input	The name of the file being read.
;	im_min	byte	input	The lowest value in the image.
;
; Action:
;	In widget mode, creates a menu to decide, otherwise, prints
;	a prompt.
;
; History:
;	Original: 3/2/93; SJT
;-

pro hdfbg_event, event

;	Event handler, very simple as the uvalues are set to the
;	required return values.

@hdfbg_wid

widget_control, event.id, get_uvalue=backact
widget_control, event.top, /destroy

end

function hdf_bg, file, im_min

;	The routine to make the prompt or menu.

@hdfbg_wid
@wid_set
@wid_fonts
;		Default is to correct if image has no zeroes in it
;		This is a characteristic of the images made by the PHA
;		software.

if (im_min eq 0) then	backact = 0 $
else			backact = 1

if (wid_mode) then begin

    menu = ['Yes', 'No']
    umen = [1,0]

    base = widget_base(title = 'HDF Background', /column, xpad = 5, $
                       ypad = 5)
    junk = widget_label(base, value = 'Greyscale HDF Background', $
		frame=2, font=large_v)

    txt = ['HDF file: '+file, $
	   'will be displayed as a greyscale image.', $
	   'Probably better '+(['not to', 'to'])(backact)+' make correction']

    junk = widget_text(base, value=txt, ysize=n_elements(txt), $
		xsize = max(strlen(txt)), font=normal_v)

    jb = widget_base(base, /row)
    junk = widget_label(jb, value='Make background correction? :', $
		font=normal_v)

    xmenu, menu, jb, /row, uvalue = umen, buttons = but, font = normal_v

    widget_control, base, /real
    widget_control, but(backact), /input

    xmanager, 'hdfbg', base, /modal	; MUST be /modal to prevent
					; Premature return
endif else begin

    print, 'Greyscale image will be produced'
    print, 'from: ', file
    cfix = ''
    deffix = (['N','Y'])(backact)

fixbackbw:
    read, 'Fix Background and Text colours? <' + deffix + '> :_', cfix
    case strupcase(cfix) of
        'Y': backact = 1
        'N': backact = 0
        '':
        else: goto, fixbackbw
    endcase
endelse

return, backact

end



