pro get_options, file, verbose = verbose

;+
;  GET_OPTIONS
;	Restores the defined variables from the setting common blocks
;	for PLOT_RATES and PLOT_CDF.
;
;  Usage:
;	get_options [, file]
;
;  Argument:
;	file	string	input	Optional filename for restore.
;
;  Keyword:
;	verbose		if set and non-zero, then print information on restore.
;
;  History:
;	Initial version: 2/7/91; SJT
;	Extended for COMP ratios: 19/7/91; SJT
;	Unified version, use IDL restore procedure: 4/9/91; SJT
;	Set replot_ok to zero so that PLOT_RATES, /REPLOT won't work: 20/9/91;
;									SJT
;	Added CDF options: 18/11/91; SJT
;	Added movie options: 21/11/91; SJT
;	Write to /read from plot directory if defined: 5/2/92; SJT
;	Add spectrum common blocks: 5/3/92; SJT
;	Added PAD common: 23/4/92; SJT
;	Add commons for PLOT_MAG: 28/4/92; SJT
;	Match commons to save_options: 5/10/94; SJT
;	Added UDS commons: 4/11/94; SJT
;-

@axis_limits
@b_axis_limits
@b_flags
@b_settings
@bg_para
@cdf_chans
@cdf_flags
@chansets
@chlist
@dcs
@directories
@file_info
@filtering
@flags
@movie_colour
@movie_set
@pad_flags
@pad_set
@plot_reg
@plot_settings
@s_axis_limits
@sect_list
@settings
@spec_flags
@spec_settings
@spool_action
@time_limits
@versions
@uds_chans
@uds_flags
@colour_tab
@track_bins
@trk_energies
@trk_maps
@pha_set
@pha_flags

if (n_params() eq 0) then begin
    file = ''
    read, 'File from which to restore settings :_', file
endif

if (n_elements(pldir) ne 0) and (strpos(file, '/') eq -1 and $
	strpos(file, ':') eq -1 and strpos(file, ']') eq -1) then $
		fsav = form_fname(file, pldir) $
else fsav = file

xdr = 0                         ; Create this variable to silence a
                                ; warning otherwise generated

restore, verbose=keyword_set(verbose), file=fsav

replot_ok = 0
cdf_replot_ok = 0
spc_replot_ok = 0
pad_replot_ok = 0
b_replot_ok = 0
uds_replot_ok = 0
pha_replot_ok = 0

end
