pro get_all, file, verbose = verbose

;+
;  GET_ALL
;	Restores the complete PLOT_RATES and PLOT\_CDF environment as saved 
;	by SAVE_ALL
;
;  Usage:
;	get_all [, file]
;
;  Argument:
;	file	string	input	Optional filename for restore.
;
;  Keyword:
;	verbose		if set and non-zero, then print information on restore.
;
;  History:
;	Initial version created from get_options: 27/9/91; SJT
;	Added CDF common blocks: 18/11/91; SJT
;	Added movie common blocks: 21/11/91; SJT
;	Write to /read from plot directory if defined: 5/2/92; SJT
;	Add spectrum common blocks: 5/3/92; SJT
;	Add PAD common: 23/4/92; SJT
;	Add commons for PLOT_MAG: 28/4/92; SJT
;	Updates common list: 19/1/92; SJT
;	Added UDS commons: 4/11/94; SJT
;-

@accumbuf
@axis_limits
@b_axis_limits
@b_data_arrays
@b_flags
@b_movie
@b_settings
@bg_para
@cdf_arrays
@cdf_chans
@cdf_flags
@chansets
@chlist
@data_arrays
@dcs
@directories
@duty_cycles
@energy_label
@energy_mfsa
@energy_para
@err_info
@file_info
@filtering
@flags
@frampar
@m_animate
@m_pl_tfm
@mov_trace
@movie_colour
@movie_energy
@movie_set
@need_sav
@pad_flags
@pad_names
@pad_sect_orient
@pad_set
@path_dirs
@plot_reg
@plot_settings
@s_axis_limits
@s_data_arrays
@sect_list
@settings
@spc_title
@spec_flags
@spec_settings
@spool_action
@time_limits
@track_bins
@trk_energies
@versions
@wid_fonts
@cospin_pars
@epacs_pars
@hiscale_pars
@swics_pars
@uds_arrays
@uds_chans
@uds_flags
@raw_ephem
@colour_tab
@trk_maps
@pha_set
@pha_flags
@pha_arrays

if (n_params() eq 0) then begin
    file = ''
    read, 'File from which to restore settings :_', file
endif

if (n_elements(pldir) ne 0) and (strpos(file, '/') eq -1 and $
	strpos(file, ':') eq -1 and strpos(file, ']') eq -1) then $
		fsav = form_fname(file, pldir) $
else fsav = file

xdr = 0                         ; Create this variable to silence a
                                ; warning otherwise generated
pulses = 0

restore, verbose=keyword_set(verbose), file=fsav

if (N_elements(pulses) gt 1) then begin
    for j = 0l, pha_ndata do begin
        have_vals = where(pulses(*, *, j) ne 0.)
        pulse_s = {counts:(pulses(*, *, j))(have_vals), $
                   Places:have_vals}
        pha_matrices(j) = handle_create(value = pulse_s)
    endfor
endif
    
need_new_window = 1             ; Make it require a new window to be
                                ; created.


end
