;+
; G_ALL_MENU
;	Widget interface for GET_ALL/OPTIONS
;
; Usage:
;	g_all_menu[, /options]
;
; Arguments:none
;
; Keywords:
;	Options			If set and non-zero then save options.
;	group	long	input	Group leader of the hierarchy
;
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original: 19/1/93; SJT
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Force scrolling if the base is too big: 21/4/94; SJT
;-

pro g_all_event, event

;	The event handler

@directories
@g_all_wid

widget_control, event.id, get_uvalue=but

case but of

;	Exits

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

    'DO': begin
	widget_control, event.top, /destroy
	if (iopts) then get_options, sfname, verbose=verb $
	else            get_all, sfname, verbose=verb
	return
    end

;	Directories

    'DAT': begin
	widget_control, dirtxt, set_value=dir
	sfdir = dir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

    'CUR': begin
	widget_control, dirtxt, set_value=currdir
	sfdir = currdir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

    'PLO': begin
	widget_control, dirtxt, set_value=pldir
	sfdir = pldir
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

    'DIR': begin
	widget_control, dirtxt, get_value=txt
	sfdir = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, filttxt, /input_focus
    end

    'FILT': begin
	widget_control, filttxt, get_value = txt
	sffilt = txt(0)
	sp = form_fname(sffilt, sfdir)
	flist = findfile(sp)
	widget_control, selmenu, set_value=flist
	sfname = ''
	widget_control, selfile, set_value = sfname
	ido = 0
	widget_control, dirtxt, /input_focus
    end

    'SELECT': begin
	sfname = flist(event.index)
	widget_control, selfile, set_value=sfname
	ido = 1
    end

;	Modes

    'VERB': verb = event.select

;	The get string (ignore)

endcase

widget_control, dobut, sensitive=ido
end

pro g_all_menu, options = options, group=group

;	Menu maker

@directories
@g_all_wid
@wid_fonts
@wid_set

if (xregistered('g_all')) then return	; Don't make a second copy.

;	Set mode

if (keyword_set(options)) then  iopts = 1 $
else				iopts = 0

;	Output file things

dirch = ['Data', 'Plot', 'Current', 'Apply']
udirc = ['DAT', 'PLO', 'CUR', 'DIR']
dirchse = [n_elements(dir) ne 0, n_elements(pldir) ne 0, 1,1]

cd, current= currdir
if (n_elements(pldir) ne 0) then begin
    sfdir = pldir
endif else begin
    sfdir = currdir
endelse
ido = 0

sffilt = '*.sav'

;	Format control

verb = 0

;	Base widgets

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(title = 'GET_ALL/OPTIONS', xpad $
                                      = 5, ypad = 5, $
                                      /column, /scroll, x_scroll_size $
                                      = xss, y_scroll_size = yss) $
else base = widget_base(title = 'GET_ALL/OPTIONS', xpad = 5, ypad = 5, $
                        /column)

if (iopts) then $
	txt = widget_label(base, value='Get options variables', $
	frame=2, font=large_v) $
else txt = widget_label(base, value='Get all common variables', $
	frame=2, font=large_v)

;	The file name

inbase = widget_base(base, /column, /frame)
junk = widget_label(inbase, value='Input file selection', font=large_v)

jb = widget_base(inbase, /column, /frame)
dirbase = widget_base(/row, jb)
dirlab = widget_label(dirbase, val='Directory', font=normal_v)
dirtxt = widget_text (/edit, dirbase, value=sfdir, uval='DIR', $
	xsize=40, ysize=1, /frame, font=normal_f)
xmenu, dirch, jb, uvalue = udirc, buttons = bid, /row, font = normal_v
for i = 0, n_elements(dirch)-1 do widget_control, bid(i), sensitive=dirchse(i)

jb = widget_base(/column, /frame, inbase)
filtbase = widget_base(/row, jb)
filtlab = widget_label(filtbase, val='Filter', font=normal_v)
filttxt = widget_text(/edit, filtbase, value=sffilt, uval='FILT', $
	xsize=40, ysize=1, /frame, font=normal_f)
junk = widget_button(jb, value='Apply', uval='FILT', font=normal_v)

selbase = widget_base(/column, /frame, inbase)
sellab = widget_label(selbase, val='File Selection Menu', font=normal_v)
sp = form_fname(sffilt, sfdir)
flist = findfile(sp)
selmenu = widget_list(selbase, val=flist, uval='SELECT', $
	ysize=6, /frame, font=normal_f)

sfname =''
sellab2 = widget_label(selbase, val='Selected File', font=normal_v)
selfile = widget_text(selbase, /frame, val=sfname, xsize=50, ysize=1, $
	font=normal_f)

;	Get mode

jb = widget_base(base, /row, /frame)
junk = widget_label(jb, value='Get option selection:', font=normal_v)
jb1 = widget_base(jb, /row)

jb2 = cw_tbutton(jb1, value = ['Quiet', 'Verbose'], uvalue = 'VERB', $
                 font = normal_v, state = verb)

;	Exit buttons

jb = widget_base(base, /row)
canbut = widget_button(jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dobut = widget_button(jb, value='Do it', uvalue='DO', font=normal_v)
widget_control, dobut, sensitive = 0

;	realize

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif


widget_control, dirtxt, /input_focus
xmanager, 'g_all', base, group=group

end
