pro Frills, on=on, off=off

;+
; FRILLS
;	Control whether to put overall headers on plots.
;
; Keywords:
;	on	input	If set then include headers & boxes (default)
;	off	input	If set then omit headers & boxes.
;
; History:
;	Original: 17/1/95; SJT
;-

@settings

if (n_elements(use_frame) eq 0) then use_frame = 1

if (keyword_set(on) and keyword_set(off)) then begin
    hs_err_msg, ["Only one keyword may be used."]
    return
endif

if (keyword_set(on)) then use_frame = 1 $
else if (keyword_set(off)) then use_frame = 0 $
else begin
    copt = (['N', 'Y'])(use_frame)
    sopt = ''
    
Get_opt:
    
    read, 'Include frames and headers? (Y/N) <'+copt+'> :_', sopt
    case strupcase(sopt) of
        'N': use_frame = 0
        'Y': use_frame = 1
        '':
        Else: goto, get_opt
    endcase
endelse

end
