function form_fname, name, dir

;+
;  FORM_FNAME
;	Forms a full filename from a name and a directory.
;
;  Usage:
;	fullname = form_fname(name, dir)
;
;  Return value:
;	fullname string		The full name of the file.
;
;  Arguments:
;	name	string	input	The name of the file (without directory).
;	dir	string	input	The directory for the file. (If it is the null
;				string then the current directory is used).
;
;  Restriction:
;	Will not always work for VMS network files, specifically the improbable
;	case of a directory given as <node name>::<disk name> without a
;	directory will fail.
;
;  History:
;	Original: 4/2/92; SJT
;-

if (n_params() ne 2) then begin
    hs_err_msg, '**** ERROR **** Must specify both arguments!'
    return, ''
endif

if (strlen(dir) eq 0) then cd, current=dir

;if !version.os ne 'vms'	then begin		; Unix system
;    if (strpos(dir,'/',strlen(dir)-1) ne -1) then return, dir + name $
;    else                                          return, dir + '/' + name 

;endif else begin				; VMS system
    if (strpos(dir,':') eq -1 and strpos(dir,']') eq -1) then $
	return, dir + ':' + name $
    else return, dir + name
;endelse

end
