pro Find_matches, pattern

;+
; FIND_MATCHES
;	find files matching the specified pattern, including
;	compressed &/| incomplete versions as appropriate.
;
; Usage:
;	find_matches, pattern
;
; Argument:
;	pattern	string	input	The pattern (excluding directory name)
;				to match.
; Restrictions:
;	Compressed names are only searched in Unix versions.
;
; History:
;	Original (adapted and extended out of make_fname): 20/10/94;
;	SJT
;-

@make_fname_cmn
@directories

tmpl = form_fname(pattern, dir)
itmpl = form_fname('i'+pattern, dir)
qtmpl = form_fname('q'+pattern, dir)
iqtmpl = form_fname('iq'+pattern, dir)

files = findfile(tmpl)
ifiles = findfile(itmpl)
qfiles = findfile(qtmpl)
iqfiles = findfile(iqtmpl)

if (!Version.os ne 'vms') then begin
    files = [temporary(files), findfile(tmpl+'.Z'), $
             findfile(tmpl+'.gz')]
    ifiles = [temporary(ifiles), findfile(itmpl+'.Z'), $
              findfile(itmpl+'.gz')]
    qfiles = [temporary(qfiles), findfile(qtmpl+'.Z'), $
              findfile(qtmpl+'.gz')]
    iqfiles = [temporary(iqfiles), findfile(iqtmpl+'.Z'), $
              findfile(iqtmpl+'.gz')]
    
    tmpl = strupcase(tmpl)
    itmpl = strupcase(itmpl)
    qtmpl = strupcase(qtmpl)
    iqtmpl = strupcase(iqtmpl)
    
    files = [temporary(files), findfile(tmpl), findfile(tmpl+'.Z'), $
             findfile(tmpl+'.gz')]
    ifiles = [temporary(ifiles), findfile(itmpl), findfile(itmpl+'.Z'), $
              findfile(itmpl+'.gz')]
    qfiles = [temporary(qfiles), findfile(qtmpl), findfile(qtmpl+'.Z'), $
              findfile(qtmpl+'.gz')]
    iqfiles = [temporary(iqfiles), findfile(iqtmpl), findfile(iqtmpl+'.Z'), $
              findfile(iqtmpl+'.gz')]
endif

files = [temporary(files), ifiles, qfiles, iqfiles]

locs = where(files ne '')
if (locs(0) eq -1) then begin
    files = ''
    return
endif

files = files(locs)

if (!Version.os eq 'vms') then sep = ']' $
else sep = '/'

for j = 0, n_elements(files)-1 do begin
    temp = str_sep(files(j), sep)
    files(j) = temp(n_elements(temp)-1)
endfor

;       Strip off VMS version numbers

if (!Version.os eq 'vms') then for i = 0, n_elements(files)-1 do begin
    semi = strpos(files(i), ';')
    if (semi gt 0) then files(i) = strmid(files(i), 0, semi)
endfor


end
    
