function expand_command, com, compress=compress

;+
; EXPAND_COMMAND
;	Expand/compress the filename in a plot spooling command
;
; Usage:
;	cmd = expand_command(com[, /compress])
;
; Return Value:
;	cmd	string		The processed command
;
; Argument:
;	com	string	input	The unprocessed command
;
; Keyword:
;	compress  ?	input	If set then compress the command into %
;				format.
;
; Method:
;	In expand mode, any occurrence of % is replaced by the current
;	filename. In compress mode any occurrence of the current
;	filename is  replaced by %
;
; History:
;	Original: 13/7/93; SJT
;-

@plot_settings

if (keyword_set(compress)) then begin
    fstr = plotfile
    flen = strlen(fstr)
    rstr = '%'
    rlen = 1
endif else begin
    fstr = '%'
    flen = 1
    rstr = plotfile
    rlen = strlen(rstr)
endelse

cmd = com

while ((p = strpos(cmd,fstr))) ne -1 do $
    cmd = strmid(cmd, 0, p) + rstr + strmid(cmd, p+flen, strlen(cmd))

return, cmd

end
