;+
; DISPLAY_LANFILE
;	Display fields from an HSIO file
;
; Usage:
;	display_lanfile[, group=group]
;
; Arguments: none
;
; Keyword:
;	group	long	input	Higher-level top-level widget with 
;				which widget is to be grouped.
;
; Restrictions:
;	This routine has no line-mode equivalent. It can be run from
;	line mode but only after widget-mod has been initialized
;	(because of font definitions).
;	Can only look at files in the current data directory.
;
; History:
;	Original: 28/10/94; SJT
;	Fix problem with inhomogeneous files: 2/11/94; SJT
;	Safety lock on non-conforming HSIO files (e.g. CDF): 21/11/94;
;	SJT
;	Modify layout to fit 1152x900 screen: 13/2/95; SJT
;	Mods to handle PRESENT field of PHA_PSUM struct: 2/5/95; SJT
;-

pro Disp_tags

@lanf_wid

if (ibod) then taglist = tag_names(rec_body) $
else           taglist = tag_names(rec_header)

widget_control, chooser, set_value = taglist

end

function Btform, vals, fmt

nv = n_elements(vals)
tmp = strarr(nv)

vals = byte(vals, 0, 4, n_elements(vals))
for j = 0, nv-1, 512 do begin
    jm = (j+511) < (nv-1)
    tmp(j:jm) = string(vals(4*j:4*(jm+1)-1), format = fmt)
endfor

return, tmp

end

pro Field_displ

@lanf_wid

if (cfindex lt 0) then begin
    widget_control, disp_txt, set_value = ''
    widget_control, tag_txt, set_value = ''
    return
endif

if (ibod) then vals = rec_body.(cfindex) $
else           vals = rec_header.(cfindex)

s = size(vals)

if (s(s(0)+1) eq 1) then begin
    if (max(vals) le 1b) then  $
      vals = string(vals, format = "("+ string(n_elements(vals))+ $
                    "I1)") $
    else vals = string(vals)
endif

s = size(vals)

if (slice ne '') then idid = execute('vals = vals('+slice+')')

case (s(s(0)+1)) of
    3: case ibase of
        0: vals = string(vals)  ; Decimal
        1: vals = btform(vals, "(4(Z2.2,1x))") ; Hex
        2: vals = btform(vals, "(4(O3.3,1x))") ; Octal
        3: vals = btform(vals, "(4(I3,1x))") ; Decimal (Byte)
    endcase
    4: vals = string(vals)
    7: vals = vals(*)
endcase

case(s(0)) of
    0: vals = cfield+' = '+vals
    1: begin
        tags = cfield+'('+strtrim(sindgen(s(1)), 2)+') = '
        if (slice ne '') then idid = execute('tags = tags('+slice+')')
        vals = tags+vals
    end
    2: begin
        tmp = lindgen(s(1), s(2))
        t1 = strtrim(string(tmp mod s(1)), 2)
        t2 = strtrim(string(tmp/s(1)), 2)
        if (slice ne '') then begin
            idid = execute('t1 = t1('+slice+')')
            idid = execute('t2 = t2('+slice+')')
        endif
        tags = cfield+'('+t1+','+t2+') = '
        vals = tags+vals
    end
    3: begin
        tmp = lindgen(s(1), s(2), s(3))
        t1 = strtrim(string(tmp mod s(1)), 2)
        t2 = strtrim(string(tmp/s(1) mod s(2)), 2)
        t3 = strtrim(string(tmp/(s(1)*s(2))), 2)
        if (slice ne '') then begin
            idid = execute('t1 = t1('+slice+')')
            idid = execute('t2 = t2('+slice+')')
            idid = execute('t3 = t3('+slice+')')
        endif
        
        tags = cfield+'('+t1+','+t2+','+t3+') = '
        vals = tags+vals
    end
    4: begin
        tmp = lindgen(s(1), s(2), s(3), s(4))
        t1 = strtrim(string(tmp mod s(1)), 2)
        t2 = strtrim(string(tmp/s(1) mod s(2)), 2)
        t3 = strtrim(string(tmp/(s(1)*s(2))) mod s(3), 2)
        t4 = strtrim(string(tmp/(s(1)*s(2)*s(3))), 2)
        if (slice ne '') then begin
            idid = execute('t1 = t1('+slice+')')
            idid = execute('t2 = t2('+slice+')')
            idid = execute('t3 = t3('+slice+')')
            idid = execute('t4 = t4('+slice+')')
        endif
        
        tags = cfield+'('+t1+','+t2+','+t3+','+t4+') = '
        vals = tags+vals
    end
endcase

widget_control, disp_txt, set_value = vals
widget_control, tag_txt, set_value = cfield

end      

pro Dsp_rd_record

@lanf_wid

read_lanfile, filenum, data, lrecl, nr, ie
ityp = ula_struct(data, rec_header, rec_body)
if (ityp le 0) then begin       ; Not a valid record
    widget_control, file_txt, set_value = ''
    widget_control, dispbase, sensitive = 0
    widget_control, pointbase, sensitive = 0
    return
endif
    
widget_control, disp_txt, set_value = ''

recno = recno+1
widget_control, rec_txt, set_value = string(recno, format = '(i4)')

orectyp = rectyp
rectyp = string(rec_header.rectyp)
widget_control, rt_txt, set_value = rectyp
if ((rectyp ne orectyp) and ibod) then begin
    widget_control, disp_txt, set_value = ''
    widget_control, tag_txt, set_value = ''
    cfindex = -1
    cfield = ''
    slice = ''
    widget_control, sl_txt, set_value = ''
endif

disp_tags

end

pro Lanf_event, event

@lanf_wid
@directories

widget_control, event.id, get_uvalue = causer

case causer of
    'EXIT': begin
        if (filename ne '') then close_lanfile, filenum
        filename = ''
        filenum = 0l
        lrecl = 0l
        widget_control, event.top, /destroy
    end
    
    'FILE': begin
        if (filename ne '') then close_lanfile, filenum
        widget_control, event.id, get_value = filename
        filename = filename(0)
        open_lanfile, form_fname(filename, dir), 0l, filenum, lrecl
        recno = 0
        if (filenum lt 0) then begin
            hs_err_msg, 'Failed to open file: '+filename
            filename = ''
        endif else begin
            map_lanfile, filenum, "", ierr
            widget_control, dispbase, /sensitive
            widget_control, pointbase, sensitive = (ierr ge 0)
            dsp_rd_record
        endelse
    end
    'MENU': begin
        ofn = filename
        filename = mk_fn_menu()
        if (filename eq '') then filename = ofn $
        else begin
            if (ofn ne '') then close_lanfile, filenum
            open_lanfile, filename, 0l, filenum, lrecl
            if (!Version.os eq 'vms') then begin
                sep = ']'
                semi = strpos(filename, ';')
                if (semi gt 0) then filename = strmid(filename, 0, semi)
            endif else sep = '/'
            temp = str_sep(filename, sep)
            filename = temp(n_elements(temp)-1)
        
            widget_control, file_txt, set_value = filename
            recno = 0
            if (filenum lt 0) then begin
                hs_err_msg, 'Failed to open file: '+filename
                filename = ''
            endif else begin
                map_lanfile, filenum, "", ierr
                widget_control, dispbase, /sensitive
                widget_control, pointbase, sensitive = (ierr ge 0)
                dsp_rd_record
            endelse
        endelse
    end
    'NEXT': if (filename ne '') then begin
        dsp_rd_record
        field_displ
    end
    'HB_TOG': begin
        ibod = event.select
        cfield = ''
        cdfindex = -1
        disp_tags
        widget_control, disp_txt, set_value = ''
        widget_control, tag_txt, set_value = ''
        slice = ''
        widget_control, sl_txt, set_value = slice
    end
    'TAGS': begin
        cfindex = event.index
        cfield = taglist(cfindex)
        slice = ''
        widget_control, sl_txt, set_value = ''
        field_displ
    end
    'SLICE': begin
        widget_control, sl_txt, get_value = slice
        slice = slice(0)
        field_displ
    end
    'POINT': begin
        widget_control, pointtxt, get_value = pointtime
        tp = conv_time_str(pointtime(0))
        seek_lanfile, filenum, tp(0), tp(1), tp(2), ipos
        recno = ipos/lrecl
        dsp_rd_record
        field_displ
    end
    
;	Base for Integer fields
    
    'DEC': begin
        ibase = 0
        field_displ
    end
    
    'HEX': begin
        ibase = 1
        field_displ
    end
    'OCT': begin
        ibase = 2
        field_displ
    end
    'DEC-B': begin
        ibase = 3
        field_displ
    end
endcase

end

pro Display_lanfile, group=group

@lanf_wid
@directories
@wid_fonts
@wid_set

if (xregistered('lanf')) then return ; Don't make a second copy

if (n_elements(dir) eq 0) then dir_menu, group = group, /modal

;	Clear file settings.

filename = ''
filenum = 0l
lrecl = 0l
recno = 0l
taglist = ['             ']
rectyp = ''
ibod = 1
cfield = ''
cfindex = -1
slice = ''

if (n_elements(ibase) eq 0) then ibase = 0
bases = ['Decimal', 'Hex', 'Octal', 'Decimal (Byte)']
ubase = ['DEC', 'HEX', 'OCT', 'DEC-B']

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(/column, title = 'HSIO Displayer',  $
                                     xpad = 5, ypad = 5, /scroll,  $
                                     x_scroll_size = xss, $
                                     y_scroll_size = yss) $
else base = widget_base(/column, title = 'HSIO Displayer', xpad = 5, $
                        ypad = 5)


junk = widget_label(base, value = 'HSIO file displayer', font = $
                    large_v, frame = 2)

; 	File & record selection.

fbase = widget_base(base, /column, /frame)

jb = widget_base(fbase, /row)
junk = widget_label(jb, value = 'File to display (in data dir):', $
                    font = normal_v)
file_txt = widget_text(jb, xsize = 16, value = '', uvalue = 'FILE', $
                       /edit, /frame, font = normal_f)
junk = widget_button(jb, value = 'Names Menu', uvalue = 'MENU', font = $
                     normal_v)

junk = widget_button(fbase, value = 'Next Record', uvalue = 'NEXT', $
                     font = normal_v)

pointbase = widget_base(fbase, /row)
junk = widget_label(pointbase, value = 'Record Time (y,d,h):', font = $
                    normal_v)
pointtxt = widget_text(pointbase, value = '', /edit, /frame, xsize = $
                       24, font = normal_f, uvalue = 'POINT')
junk = widget_button(pointbase, value = 'Apply', uvalue = 'POINT', $
                     font = normal_v)

;	Base selection for integers (ignored for floats &
;	strings). (Open Look)

if (wid_version.style eq 'OPEN LOOK') then begin
    formbase = widget_base(fbase, /row)
    junk = widget_label(formbase, value = 'Integer Base', font = normal_v)
    xmenu, bases, formbase, /row, /exclusive, /no_release, uvalue = ubase, $
      button = bid, font = normal_v
    widget_control, bid(ibase), /set_button
endif

;	The main display base has 3 components:
;	1) A chooser to select the tag to display. (includes the base
;	selector in motif systems)
;	2) An info line giving record type.
;	3) The main display field.

dispbase = widget_base(base, /row, /frame)
chbase = widget_base(dispbase, /column, /frame)
junk = widget_label(chbase, value = 'Field Selection', font = normal_v)
junk = cw_tbutton(chbase, value = ['Header', 'Body'], state = ibod, $
                  font = normal_v, uvalue = 'HB_TOG')
chooser = widget_list(chbase, value = taglist, uvalue = 'TAGS', ysize $
                      = 20, font = normal_f)

;	Base selection for integers (ignored for floats &
;	strings). (Motif)

if (wid_version.style eq 'Motif') then begin
    junk = widget_label(chbase, value = 'Integer Base', font = normal_v)
    xmenu, bases, chbase, /column, /exclusive, /no_release, uvalue = ubase, $
      button = bid, font = normal_v
    widget_control, bid(ibase), /set_button
endif

dispb2 = widget_base(dispbase, /column, /frame)
jb = widget_base(dispb2, /row)
junk = widget_label(jb, value = 'Record: type:', font = normal_v)
rt_txt = widget_text(jb, xsize = 4, font = normal_f, value = rectyp)
junk = widget_label(jb, value = ' number:', font = normal_v)
rec_txt = widget_text(jb, xsize = 4, font = normal_f, value = $
                      string(recno, format = '(i4)'))
junk = widget_label(jb, value = ' Field:', font = normal_v)
tag_txt = widget_text(jb, xsize = 10, font = normal_v, value = cfield)

disp_txt = widget_text(dispb2, xsize = 40, ysize = 26, /scroll, font = $
                       normal_f, value = '')
jb1 = widget_base(dispb2, /row)
junk = widget_label(jb1, value = 'Data slice:', font = normal_v)
sl_txt = widget_text(jb1, /edit, /frame, xsize = 25, value = slice, $
                     uvalue = 'SLICE', font = normal_f)

widget_control, dispbase, sensitive = 0

; Exit  button

qb = widget_button(base, value = 'Exit', uvalue = 'EXIT', font = normal_v)

;	Realize and xmanage

widget_control, base, /real, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1) and not iscroll) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

xmanager, 'lanf', base, group = group

end
