;+
; DIR_MENU
;	Choose the directories to be used 	(a) to read the data and
;						(b) to put any hard copy plots
;
; Call:
;	dir_menu
;
; Argument:
;
; Keywords:
;	group	long	input	Group leader of the hierarchy
;	modal			If set and non-zero, then make it modal.
;
; Restrictions:
;	Not intended to be called directly
;
; History:
;	Original derived from SET_DIR
;	Added group keyword: 22/1/93; SJT
;	Use xregistered instead of /modal to make it one copy only:
;						3/2/93; SJT
;	Rotate input focus: 11/2/93; SJT
;	Add modal key: 28/10/94; SJT
;-

pro dir_event, event

@directories
@dir_wid

widget_control, get_uval=i, event.id

case i of
;	Exit events

    'Done': begin
	widget_control, dir_id, get_val=ds
	dir = ds(0)
	widget_control, plot_id, get_val=ds
	pldir = ds(0)
	widget_control, event.top, /destroy

;	If vms we must translate the logical for the directory out to its end,
;	otherwise the make_fname procedure won't work properly.

	if (!version.os eq 'vms') then repeat itr = trnlog(dir,dir) $
				       until itr mod 2 eq 0
	
	return
    end

    'CANCEL': begin
	widget_control, event.top, /destroy
	return
    end

;	Switch input focus on events from the text widgets

    'DIR': widget_control, plot_id, /input_focus
    'PLOT': widget_control, dir_id, /input_focus

;	Copy widgets

    'P-D': begin
	widget_control, plot_id, get_val=ds
	widget_control, dir_id, set_val=ds, /input_focus
    end

    'D-P': begin
	widget_control, dir_id, get_val=ds
	widget_control, plot_id, set_val=ds, /input_focus
    end
endcase

end

pro dir_menu, group=group, modal=modal

@directories
@dir_wid
@wid_fonts

if (xregistered('dir')) then return	; Don't make a second copy.

if (n_elements(dir) eq 0) then cd, curr=defd $
else			defd = dir

if (n_elements(pldir) eq 0) then defp = defd $
else			defp = pldir

base = widget_base(/column, xpad=5, ypad=5, title='Directories')
txt = widget_label (base, value='Set Directory', frame=2, font=large_v)

dbase = widget_base(base, /row, /frame)
dl = widget_label(dbase, value='Data Directory', font=normal_v)
dir_id = widget_text(dbase, /edit, value=defd, uvalue='DIR', $
	/frame, ysize=1, xsize=40, font=normal_f)

junk = widget_button(dbase, value='Plot', uvalue='P-D', font=normal_v)

pbase = widget_base(base, /row, /frame)
pl = widget_label(pbase, value='Plot Directory', font=normal_v)
plot_id = widget_text(pbase, /edit, value=defp, uvalue='PLOT', $
	/frame, ysize=1, xsize=40, font=normal_f)
junk = widget_button(pbase, value='Data', uvalue='D-P', font=normal_v)

;	 A button to return to the main menu

jb = widget_base(base, /row)
cbut = widget_button (jb, value='Cancel', uvalue='CANCEL', font=normal_v)
dbut = widget_button (jb, value='Done', uvalue='Done', font=normal_v)

widget_control, /real, base
widget_control, dir_id, /input_focus
xmanager, 'dir', base, group=group, modal = modal

end
