pro df_pal_col, a1, a2, a3, a4, white=white

;+
; DF_PAL_COL
; 	Loads a colour table from an HDF style palette (i.e. RGBRGB....),
;	or from 3 separate arrays of red, green & blue.
;
; Usage:
;	df_pal_col, pal, mimg[, white=white]
; or    df_pal_col, r, g, b, mimg[, white=white]
;
; Arguments:
;	pal	byte	input	the palette.
;	r	byte	input	red values
;	g	byte	input	green values
;	b	byte	input	blue values
;	mimg	byte	input	The palette shift (normally the minimum value
;				in the image).
;
; Keywords:
;	white	int	input	colour index or indices to make white.
;
; History:
;	Original: 20/2/91; SJT
;	Separated out for SHOW_HDF: 28/4/92; SJT
;	Add offset to cope with APL slipped colour tables: 28/10/92; SJT
;	Allow passing of 2 or 4 arguments: 24/10/92; SJT
;	Add white keyword: 2/9/93; SJT
;-

if (n_params() le 2) then begin		; all in one palette (VMS)
    pal = reform(a1, 3, 256)
    r = pal(0,*)
    g = pal(1,*)
    b = pal(2,*)
    if (n_params() eq 2) then mimg = a2 $
    else mimg = 0
endif else begin			; separate (unix)
    r = a1
    g = a2
    b = a3
    if (n_params() eq 4) then mimg = a4 $
    else mimg = 0
endelse

if (keyword_set(white)) then begin
   r(white-mimg) = 255b
   g(white-mimg) = 255b
   b(white-mimg) = 255b
endif

tvlct, r, g, b, mimg

end
