pro Date_format, month=month, doy=doy

;+
; DATE_FORMAT
;	Control whether to use day of year or month and day
;
; Keywords:
;	month	input	If set then use month and day
;	doy	input	If set then use day of year
;
; History:
;	Original (from frills): 16/2/95; SJT
;-

@settings

if (n_elements(use_date) eq 0) then use_date = 0

if (keyword_set(month) and keyword_set(doy)) then begin
    hs_err_msg, ["Only one keyword may be used."]
    return
endif

if (keyword_set(month)) then use_date = 1 $
else if (keyword_set(doy)) then use_date = 0 $
else begin
    copt = (['D', 'M'])(use_date)
    sopt = ''
    
Get_opt:
    
    read, 'Use day of year (D) or month and date (M)? <'+copt+'> :_', sopt
    case strupcase(sopt) of
        'D': use_date = 0
        'M': use_date = 1
        '':
        Else: goto, get_opt
    endcase
endelse

end
