pro Cursor_within, x, y

;+
; CURSOR_WITHIN
;	Select the plot transform, within whose region the cursor
;	lies.
;
; Usage:
;	cursor_within, x, y
;
; Arguments:
;	x,y	float	input	Normalized cursor coordinates.
;
; Restriction:
;	If the cursor is not in any region then the transforms are
;	unchanged.
;
; History:
;	Original: 1/6/94; SJT
;-

@trans_stack

if (x ge ptfm(ctfm).region(0) and x lt ptfm(ctfm).region(2) and $
    y ge ptfm(ctfm).region(1) and y lt ptfm(ctfm).region(3)) then $
  return

for j = 0, n_elements(istime)-1 do begin
    if (x ge ptfm(j).region(0) and x lt ptfm(j).region(2) and $
        y ge ptfm(j).region(1) and y lt ptfm(j).region(3)) then begin
        ctfm = j
        !P = ptfm(j)
        !X = xtfm(j)
        !Y = ytfm(j)
        return
    endif
endfor

end
