function conv_time_str, st, seconds=seconds

;+
;  CONV_TIME_STR
;	
;	Convert a time string into a 4 (or 5) element time array.
;
;  Call:
;	time_array = conv_time_str(time_string[, /seconds])
;
;  Return Value:
;	time_array	int	4 or 5  - element array with [year, day, hour, min]
;
;  Argument:
;	time_string	string	input	String with year, day, hour, min
;					separated by commas.
;
;  Keyword:
;	second	?	input	If set and non-zero, then return a 5 -element
;				array.
;
;  History:
;	Spun out from TIME: 28/8/91; SJT
;	Added option for 5-element time: 30/1/92; SJT
;	Ensure time is valid: 24/8/93; SJT
;-

if (keyword_set(seconds)) then begin
    time_array = intarr(5)
    imax = 4
endif else begin
    time_array = intarr(4)
    imax = 3
endelse

c=-1
for i =0,imax do begin
    oc = c+1
    c = strpos(st, ',', oc)
    if (c eq -1) then begin                     ; No more commas take rest
        ss = strmid(st, oc, strlen(st))
        time_array(i) = fix(ss)
	ilast = i
        goto, check_time
    endif else begin
        ss = strmid(st, oc, c-oc)
        time_array(i) = fix(ss)
    endelse
endfor

ilast = imax

check_time:
time_array = norm_time(time_array)

return, time_array
end
