;+
; CONT_PROMPT
;	A prompt to continue, or quit in suitable mode.
;
; Usage:
;	action = cont_prompt()
;
; Arguments & Keywords: none
;
; Return Value:
;	action	int	1 to continue, 0 to quit
;
; History:
;	Original: 25/1/93; SJT
;	Re written as a function: 3/2/93; SJT
;	Add 'pop to front': 17/11/95; SJT
;-

pro cont_event, event

;	Event handler if in widget mode.

@cont_wid
@wid_set

widget_control, event.id, get_uvalue = uv

if (uv eq -7) then begin
    widget_control, event.top, /show
    widget_control, event.id, timer = 2.0
endif else begin
    action = uv
    widget_control, event.top, /destroy
    widget_control, topbase, /hourglass
endelse

end

function cont_prompt

;	The prompter, or menu maker

@wid_set
@cont_wid
@plot_settings
@wid_fonts

action = ''

;	If not in widget mode, then a simple prompt

if (not wid_mode) then begin
    on_ioerror, quitstat
    sact = ''
contact:
    read, 'Press <return> to continue, q to quit ...', sact
    sact=strlowcase(sact)
    case sact of
	'q': action = 0
	'': action = 1
	else: goto, contact
    endcase
endif else begin

;	Otherwise a simple message and menu.

    set_plot, wid_dev

    msg = ['Press "Continue" to continue', 'Press "Quit" to exit']
    acts = ['Continue', 'Quit']
    uacts = [1, 0]


    base = widget_base(title='CONT_PROMPT', /column, xpad=5, ypad=5)
    txt = widget_label(base, value = 'Continue or Quit', font = $
                       large_v, uvalue = -7)

    junk = widget_text(base, value=msg, xsize=max(strlen(msg)), $
	ysize=n_elements(msg), font=normal_v)

    xmenu, acts, base, uvalue = uacts, /row, buttons = bids, font = $
      normal_v
    
    widget_control, base, /real
    widget_control, bids(0), /input_focus
    widget_control, txt, timer = 2.0
    
    xmanager, 'cont', base, /modal	; MUST be /modal to prevent
					; premature return.

    set_plot, devname
endelse

return, action

quitstat:
return, 0

end

