function compare_version, hds, first

;+
;  COMPARE_VERSION
;	Compares the version number of the file with that of the initial file,
;	or stores the information for the first file.
;
;  Call:
;	rc = compare_version (hds, first)
;
;  Return Value:
;	rc	int	0 if O.K. or mismatch to be ignored, 1 if to truncate
;			after mismatch, -1 for abort.
;
;  Arguments:
;	hds	struct	input	The structure (type {ULA_RH}) with the
;				header.
;	first	int	in/out	1 if this is the first file, 0 otherwise,
;				always 0 on return.
;
;  History:
;	Original: 2/1/92; SJT
;	Add use of mm_action to choose action on mismatch: 16/12/92; SJT
;	Remove SFDU0 from consideration: 25/8/93; SJT
;	Add check on TRK PHA versions: 23/5/95; SJT
;	Add support for EPAM here: 13/11/97; SJT
;-

@versions
@wid_set
@settings
@track_bins

if (n_elements(mm_action) eq 0) then mm_action = 0

hst = string(hds.history)

p = strpos(hst(5), ':')

if (p ne -1) then vn = float(strmid(hst(5),p+1,16)) $
else		  vn = 0

if (first) then begin		; On the first pass store the version info.
    vers_no = vn
    history = hst
    first = 0
    instrument = hds.ibrate eq 168 ; 1 for EPAM, 0 for HI-SCALE
    help, call = calls
    pr = total(strpos(calls, 'PLOT_RATES'))+n_elements(calls)
    if (pr gt 0) then  $
      if (flux eq 6 or flux eq 8) then begin ; Check PHA maps match
        p = strpos(history(6), ':')
        itr = fix(strmid(history(6), p+1, 2))
        if (itr ne trk_version) then begin
            errmsg1 = string(itr, trk_version, format =  $
                             "('** WARNING ** Track file not generated " + $
                             "with selected PHA map'/" + $
                             "'Track file: ',I2,' Chosen: ',I2/" + $
                             "'values plotted may be invalid')")
            if (mm_action eq 0) then begin
                iact = version_mm(errmsg1, /notruncate)
                case strupcase(iact) of
                    'A': return, -1
                    'C': return, 0
                endcase
            endif else begin
                hs_err_msg, errmsg1
                if (mm_action ge 3) then return, -1 $
                else return, 0
            endelse
        endif
    endif
    
endif else begin		; On the rest compare and take action
    
    finst = hds.ibrate eq 168
    if (finst ne instrument) then begin ; Can't mix & match HISCALE &
                                ; EPAM -- truncate NOW.
        ilist = ['HISCALE', 'EPAM']
        errmsg1 = string (ilist(finst), ilist(instrument), format = $
                          "('*** ERROR *** Cannot append ',A,' data to ',A)")
        if (mm_action eq 4) then return, -1 $
        else return, 1
    endif
    
    if (vn eq vers_no) then return, 0

    if (mm_action ne 1) then begin
	errmsg1 = string(vn, vers_no, $
		format="('** WARNING ** Versions do not match'/" + $
	    "'New file has version = ',f5.2,' Old had version = ', F5.2/" + $
	    "/T20,'History blocks are:'/T20,'New',T40,'Old')")
	errmsg2 = strarr(10)
	for j = 0, 9 do errmsg2(j) = string(hst(j),history(j), $
		format="(T20,A,T40,A)")
	if (mm_action ge 2) then begin
	    iact = (['Continuing', 'Truncating', 'Aborting'])(mm_action-2) $
		+' plot'
	    err = [errmsg1, errmsg2, iact]

	    hs_err_msg, err
	endif
    endif

action:
    case mm_action of 
	0: begin
	    iact = version_mm([errmsg1, errmsg2])
	    case strupcase(iact) of
		'A': return, -1
		'T': return, 1
		'C': return, 0
	    endcase
	end
	1: return, 0
	2: return, 0
	3: return, 1
	4: return, -1
    endcase
endelse

return, 0

end
