function compare_times, t1, t2

;+
;  COMPARE_TIMES
;	Compare two times given in the form y, d, h, m, (s). Making the
;	comparison mod 100 for the year, and in such a way as to avoid problems
;	with leap years.
;
;  Usage:
;	reln = compare_times (t1, t2)
;
;  Arguments:
;	t1	float	input	Array with first time (4 or 5 elements)
;	t2	float	input	Array with second time.
;
;  Return value:
;	reln	int	1 if t1 > t2, -1 if t1 < t2, 0 if t1 = t2
;
;  History:
;	Original: 18/9/91; SJT
;	Fix for dates beyond 2000: 1/12/95; SJT
;-

dhms = [1.d0, 24.d0, 1.44d3, 8.64d4]		; To convert d, h, m, s to dp
						; days

y1 = date100(t1(0))
y2 = date100(t2(0))

if (y1 gt y2) then return, 1
if (y1 lt y2) then return, -1

d1 = total(t1(1:*) / dhms)
d2 = total(t2(1:*) / dhms)

if (d1 gt d2) then return, 1
if (d1 lt d2) then return, -1

return, 0

end
