;+
; COLOUR_MENU
;	Widget based colour editor for IDL_HS.
;
; Usage:
;	colour_menu[, group=group]
;
; Keyword:
;	group	long	input	Group leader of the current widget.
;
; Restrictions:
;	Only operates on the bottom 16 colours (these are the ones
;	used by idl_hs.
;
; History:
;	Original: 12/1/95; SJT
;-

pro Colour_event, event

@colour_tab
@col_wid

widget_control, event.id, get_uvalue = but

case but of
    "DO": widget_control, event.top, /destroy
    
    "RESTORE": begin
        red(2:*) = [255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
                    0b, 127b, 255b, 85b, 170b]
        gre(2:*) = [0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
                    127b, 0b, 0b, 85b, 170b]
        blu(2:*) = [0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
                    255b, 255b, 127b, 85b, 170b]
        tvlct, red, gre, blu
        widget_control, event.top, /destroy
    end
    
    "RED": begin
        widget_control, event.id, get_value = val
        red(cci) = val
        tvlct, red(cci), gre(cci), blu(cci), cci
    end
    
    "GRE": begin
        widget_control, event.id, get_value = val
        gre(cci) = val
        tvlct, red(cci), gre(cci), blu(cci), cci
    end
    
    "BLU": begin
        widget_control, event.id, get_value = val
        blu(cci) = val
        tvlct, red(cci), gre(cci), blu(cci), cci
    end
    
    Else: begin
        cci = float(but)
        widget_control, index_label, set_value =  $
          "Define colour index" + string(cci, format = "(i2)")
        widget_control, sli(0), set_value = red(cci)
        widget_control, sli(1), set_value = gre(cci)
        widget_control, sli(2), set_value = blu(cci)
    end
endcase

end

pro Colour_menu, group=group

@colour_tab
@wid_fonts
@col_wid
@plot_settings

if (xregistered("colour")) then return ;Don't make multiple copies

if (n_elements(cci) eq 0) then cci = 2

if (n_elements(bg) eq 0) then bg = 'B'
if (bg eq 'B') then begin
    bbc = 0b
    bfg = 255b
endif else if (bg eq 'W') then begin
    bbc = 255b
    bfg = 0b
endif
if (n_elements(red) eq 0) then begin
    red = [bbc, bfg, 255b, 0b, 0b, 0b, 255b, 255b, 255b, 127b, 0b, $
           0b, 127b, 255b, 85b, 170b]
    gre = [bbc, bfg, 0b, 255b, 0b, 255b, 0b, 255b, 127b, 255b, 255b, $
           127b, 0b, 0b, 85b, 170b]
    blu = [bbc, bfg, 0b, 0b, 255b, 255b, 255b, 0b, 0b, 0b, 127b, $
           255b, 255b, 127b, 85b, 170b]
endif 
tvlct, red, gre, blu

base = widget_base(/column, title = 'Colour Selector', xpad = 5, ypad $
                   = 5)

junk = widget_label(base, value = "Colour Selector", font = large_v, $
                    frame = 2)


cb = widget_base(base, column = 4, /frame)
pals = lonarr(16)
for j = 0, 15 do $
  pals(j) = widget_draw(cb, xsize = 64, ysize = 32, uvalue = $
                        strtrim(string(j), 2), $
                        button_events = (j ge 2), frame = (j ge 2))


jb = widget_base(base, /column, /frame)

index_label = widget_label(jb, value = "Define colour index"+ $
                           string(cci, format = "(i2)"), font = $
                                  normal_v)
jbb = widget_base(jb, /column)

sli = lonarr(3)
sli(0) = widget_slider(jbb, min = 0, max = 255, value = red(cci), $
                       uvalue = "RED", font = normal_v, title = "Red", $
                       xsize = 256)
sli(1) = widget_slider(jbb, min = 0, max = 255, value = gre(cci), $
                       uvalue = "GRE", font = normal_v, title = "Green", $
                       xsize = 256)
sli(2) = widget_slider(jbb, min = 0, max = 255, value = blu(cci), $
                       uvalue = "BLU", font = normal_v, title = "Blue", $
                       xsize = 256)

jb = widget_base(base, /row)
junk = widget_button(jb, value = "Restore Default", uvalue = $
                     "RESTORE", font = normal_v)
junk = widget_button(jb, value = "Do it", uvalue = "DO", font = $
                     normal_v)

widget_control, base, /real

im = bytarr(68, 36)
wgraph = !d.window
for j = 0, 15 do begin
    widget_control, pals(j), get_value = ipal
    wset, ipal
    im(*) = j
    tv, im
endfor
if (wgraph ne -1) then wset, wgraph

xmanager, 'colour', base, group = group

end
