pro Close_plot, nospool=nospool

;+
;  CLOSE_PLOT
;	Closes plot device, in a sensible way and offers chance to plot
;	hardcopy.
;
;  Usage:
;	close_plot
;
;  Arguments: none
;
;  Keywords:
;	nospool	input	If set, then dont attempt to spool the
;			hardcopy file
;			
;  History:
;	Extracted from PLOT_DATA: 29/1/92; SJT
;	Add retention of Action: 31/1/92; SJT
;	Add LN03 "Pseudo-device": 28/7/94;SJT
;-

@directories
@plot_settings
@spool_action
@wid_set

!p.position = 0 & !p.region = 0

if (!D.flags and 512) ne 0 or pldname eq 'ln03' $
  then begin                    ; For a hardcopy device
    if (n_elements(spool_cmd) eq 0) then spool_cmd = $
      getenv('HS_PRINT')
    if (pldname eq 'ln03') then erase
    device, /close
    if (keyword_set(nospool)) then goto, safety
    
    if (wid_mode) then begin
	set_plot, wid_dev
	plcl_menu
    endif else begin
        cd, pldir, current=currdir
        on_ioerror, safety
        com = '' 
        print, 'To do nothing enter space, to reset default'+ $
		' to no-action enter 2 spaces'
	print, 'The symbol % denotes the filename.'
	read, 'OS command to spool hardcopy <'+spool_cmd+'> :_', com
        case com of
	    '':    com = spool_cmd		; Do previous action
	    '  ':  begin
	        spool_cmd = ''			; Do nothing, and clear 
	        com = ''			; default action
	    end
	    ' ': com = ''			; Do nothing but don't clear
	   else: spool_cmd = com		; Reset default and do it.
        endcase

        if com ne '' then begin
            cmd = expand_command(com)
            if !version.os eq 'vms' then begin
	        if (strpos(cmd,'&',strlen(cmd)-1) ne -1) then $
		    spawn, strmid(cmd,0,strlen(cmd)-1), /nowait, /notify $ 
                else spawn, cmd
	    endif else spawn, cmd
        endif
safety:
        cd, currdir
    endelse

endif else if (!d.name eq 'TEK' and plotfile ne '') then device, /close

if (wid_mode) then set_plot, wid_dev

end

