;+
; BL_HELP_MENU
;	Display HELP info on common blocks.
;
; Usage:
;	bl_help_menu[, group=group]
;
; Keyword:
;	group	long	input	Widget ID of group leader.
;
; Restrictions:
;	Widget interface, but only returns to the terminal (a
;	limitation of the HELP utility).
;
; History:
;	Original idea: 3/5/95; SJT
;	Autogenerated: 5/12/97; mk_block_help
;-
pro block_event,event

widget_control, event.id, get_uvalue=but

case but of
    'Quit': widget_control, event.top, /destroy

    'accumbuf': accumbuf_hlp
    'axis_limits': axis_limits_hlp
    'b_axis_limits': b_axis_limits_hlp
    'b_data_arrays': b_data_arrays_hlp
    'b_flags': b_flags_hlp
    'b_movie': b_movie_hlp
    'b_settings': b_settings_hlp
    'bg_para': bg_para_hlp
    'cdf_arrays': cdf_arrays_hlp
    'cdf_chans': cdf_chans_hlp
    'cdf_flags': cdf_flags_hlp
    'chansets': chansets_hlp
    'chlist': chlist_hlp
    'colour_tab': colour_tab_hlp
    'cospin_pars': cospin_pars_hlp
    'data_arrays': data_arrays_hlp
    'dcs': dcs_hlp
    'directories': directories_hlp
    'duty_cycles': duty_cycles_hlp
    'energy_label': energy_label_hlp
    'energy_mfsa': energy_mfsa_hlp
    'energy_para': energy_para_hlp
    'epacs_pars': epacs_pars_hlp
    'err_info': err_info_hlp
    'file_info': file_info_hlp
    'filtering': filtering_hlp
    'flags': flags_hlp
    'frampar': frampar_hlp
    'hiscale_pars': hiscale_pars_hlp
    'hsio_entry': hsio_entry_hlp
    'm_animate': m_animate_hlp
    'm_images': m_images_hlp
    'm_pl_tfm': m_pl_tfm_hlp
    'make_fname_cmn': make_fname_cmn_hlp
    'mov_trace': mov_trace_hlp
    'movie_colour': movie_colour_hlp
    'movie_energy': movie_energy_hlp
    'movie_set': movie_set_hlp
    'need_sav': need_sav_hlp
    'pad_flags': pad_flags_hlp
    'pad_names': pad_names_hlp
    'pad_sect_orient': pad_sect_orient_hlp
    'pad_set': pad_set_hlp
    'path_dirs': path_dirs_hlp
    'pha_arrays': pha_arrays_hlp
    'pha_flags': pha_flags_hlp
    'pha_set': pha_set_hlp
    'plot_reg': plot_reg_hlp
    'plot_settings': plot_settings_hlp
    'raw_ephem': raw_ephem_hlp
    's_axis_limits': s_axis_limits_hlp
    's_data_arrays': s_data_arrays_hlp
    'sect_list': sect_list_hlp
    'settings': settings_hlp
    'spc_title': spc_title_hlp
    'spec_flags': spec_flags_hlp
    'spec_settings': spec_settings_hlp
    'spool_action': spool_action_hlp
    'swics_pars': swics_pars_hlp
    'swoops_pars': swoops_pars_hlp
    'time_limits': time_limits_hlp
    'track_bins': track_bins_hlp
    'trans_stack': trans_stack_hlp
    'trk_energies': trk_energies_hlp
    'trk_maps': trk_maps_hlp
    'uds_arrays': uds_arrays_hlp
    'uds_chans': uds_chans_hlp
    'uds_flags': uds_flags_hlp
    'versions': versions_hlp
    'wid_fonts': wid_fonts_hlp
    'wid_set': wid_set_hlp
endcase
end
pro bl_help_menu, group=group




if (xregistered('block')) then return	; Don't make a second copy.

buttons = ['accumbuf', $
           'axis_limits', $
           'b_axis_limits', $
           'b_data_arrays', $
           'b_flags', $
           'b_movie', $
           'b_settings', $
           'bg_para', $
           'cdf_arrays', $
           'cdf_chans', $
           'cdf_flags', $
           'chansets', $
           'chlist', $
           'colour_tab', $
           'cospin_pars', $
           'data_arrays', $
           'dcs', $
           'directories', $
           'duty_cycles', $
           'energy_label', $
           'energy_mfsa', $
           'energy_para', $
           'epacs_pars', $
           'err_info', $
           'file_info', $
           'filtering', $
           'flags', $
           'frampar', $
           'hiscale_pars', $
           'hsio_entry', $
           'm_animate', $
           'm_images', $
           'm_pl_tfm', $
           'make_fname_cmn', $
           'mov_trace', $
           'movie_colour', $
           'movie_energy', $
           'movie_set', $
           'need_sav', $
           'pad_flags', $
           'pad_names', $
           'pad_sect_orient', $
           'pad_set', $
           'path_dirs', $
           'pha_arrays', $
           'pha_flags', $
           'pha_set', $
           'plot_reg', $
           'plot_settings', $
           'raw_ephem', $
           's_axis_limits', $
           's_data_arrays', $
           'sect_list', $
           'settings', $
           'spc_title', $
           'spec_flags', $
           'spec_settings', $
           'spool_action', $
           'swics_pars', $
           'swoops_pars', $
           'time_limits', $
           'track_bins', $
           'trans_stack', $
           'trk_energies', $
           'trk_maps', $
           'uds_arrays', $
           'uds_chans', $
           'uds_flags', $
           'versions', $
           'wid_fonts', $
           'wid_set']

iscroll = 0

Make_menu:

if (iscroll) then base = widget_base(/column, title = 'Common ' + $
                                        'Blocks', /scroll, $
                                        x_scroll_size = xss, $
                                        y_scroll_size = yss) $
else base = widget_base(/column, title = 'Common Blocks')

junk = widget_label(base, value = 'Common Block Help', frame = 5, font $
                    = large_v)

xmenu, buttons, base, column = 6, font = normal_v, uvalue = buttons

qb = widget_button(base, value = 'Quit', uvalue = 'Quit', font = $
                   normal_v)

widget_control, /real, base, tlb_get_size = wid_size

if (wid_size(0) gt 0.9*screen_size(0) or wid_size(1) gt $
    0.9*screen_size(1)) then begin
    widget_control, base, /destroy
    iscroll = 1
    xss = screen_size(0)*0.9 < (wid_size(0) + 40)
    yss = screen_size(1)*0.9 < (wid_size(1) + 40)
    goto, make_menu
endif

xmanager, 'block', base, group=group

end
