;+
; BACK_THR_MENU
;
; Usage:
;	back_thr_menu, group=group
;
; Keyword:
;	group	long	input	group leader of the hierarchy
;
; Restrictions:
;	Not intended to be called directly.
;
; History:
;	Original: 18/11/93; SJT
;-

pro back_thr_event, event

@bgt_wid
@bg_para
@flags
@pad_flags
@spec_flags
@settings

widget_control, get_uvalue=but, event.id

if (but ne 'Cancel') then begin
    widget_control, thrtxt, get_value=sth
    reads, sth, bg_thresh
    if (bg_subtract) then begin
	if (bg_flag) then replot_ok = 0
	spc_replot_ok = 0
	pad_replot_ok = 0
    endif
endif

widget_control, /destroy, event.top

end

pro back_thr_menu, group = group

@bg_para
@wid_fonts
@bgt_wid
@flags
@settings

;	Check if already present

if (xregistered('back_thr')) then return

if (n_elements(bg_thresh) eq 0) then bg_thresh = 2.
if (n_elements(bg_subtract) eq 0) then bg_subtract = 0
if (n_elements(bg_flag) eq 0) then bg_flag = 0

bnames = ['Cancel', 'Apply']

;	Base & title

base = widget_base(/column, xpad = 5, ypad = 5, title = 'Threshold')
jukn = widget_label(base, value='Background Threshold', frame=2, $
	font=large_v)

;	Setting box.

jb = widget_base(base, /row)
junk = widget_label(jb, value='Threshold level (sigma):', font=normal_v)
thrtxt = widget_text(jb, /frame, /edit, xsize=12, uvalue='t_hold', $
		value=string(bg_thresh), font=normal_f)

;	Control buttons.

xmenu, bnames, base, uvalue = bnames, font = normal_v, /row

widget_control, base, /real
xmanager, 'back_thr', base, group=group

end
